/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructAPI;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;

public class CulinaryConstructConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.culinaryconstruct.config.";

    public static boolean isBlacklistedIngredient(ItemStack stack) {
        ResourceLocation location;
        Item item = stack.func_77973_b();
        Food food = item.func_219967_s();
        LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructAPI.getCulinaryIngredient(stack);
        int foodAmount = 0;
        float saturationAmount = 0.0f;
        if (culinary.isPresent()) {
            foodAmount = (Integer)culinary.map(ICulinaryIngredient::getFoodAmount).orElse((Object)0);
            saturationAmount = ((Float)culinary.map(ICulinaryIngredient::getSaturation).orElse((Object)Float.valueOf(0.0f))).floatValue();
        } else if (food != null) {
            foodAmount = food.func_221466_a();
            saturationAmount = food.func_221469_b();
        }
        int maxFood = (Integer)CulinaryConstructConfig.SERVER.maxIngredientFood.get();
        double maxSaturation = (Double)CulinaryConstructConfig.SERVER.maxIngredientSaturation.get();
        List blacklist = (List)CulinaryConstructConfig.SERVER.ingredientBlacklist.get();
        boolean blacklisted = false;
        if (!blacklist.isEmpty() && (location = item.getRegistryName()) != null) {
            blacklisted = blacklist.contains(location.toString());
        }
        return maxFood >= 0 && foodAmount > maxFood || maxSaturation >= 0.0 && (double)saturationAmount > maxSaturation || blacklisted;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue maxFoodPerSandwich;
        public final ForgeConfigSpec.DoubleValue maxIngredientSaturation;
        public final ForgeConfigSpec.IntValue maxIngredientFood;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ingredientBlacklist;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            this.maxFoodPerSandwich = builder.comment("The maximum amount of food that a single sandwich can give").translation("gui.culinaryconstruct.config.maxFoodPerSandwich").defineInRange("maxFoodPerSandwich", 10, 1, 100);
            this.maxIngredientSaturation = builder.comment("Blacklist ingredients with more than this max saturation modifier, -1 to disable").translation("gui.culinaryconstruct.config.maxIngredientSaturation").defineInRange("maxIngredientSaturation", -1.0, -1.0, 100.0);
            this.maxIngredientFood = builder.comment("Blacklist ingredients with more than this max food value, -1 to disable").translation("gui.culinaryconstruct.config.maxIngredientFood").defineInRange("maxIngredientFood", -1, -1, 100);
            this.ingredientBlacklist = builder.comment("List of items to blacklist as ingredients").translation("gui.culinaryconstruct.config.ingredientBlacklist").defineList("ingredientBlacklist", new ArrayList(), s -> s instanceof String);
        }
    }
}

