/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;

public class CraftFoodTrigger
implements ICriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("culinaryconstruct", "craft_food");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners foodListeners = this.listeners.get(playerAdvancementsIn);
        if (foodListeners == null) {
            foodListeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, foodListeners);
        }
        foodListeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        Listeners foodListeners = this.listeners.get(playerAdvancementsIn);
        if (foodListeners != null) {
            foodListeners.remove(listener);
            if (foodListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance();
    }

    public void trigger(ServerPlayerEntity player) {
        Listeners foodListeners = this.listeners.get(player.func_192039_O());
        if (foodListeners != null) {
            foodListeners.trigger();
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger() {
            for (ICriterionTrigger.Listener listener : Lists.newArrayList(this.listeners)) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        public Instance() {
            super(ID);
        }
    }
}

