/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructAPI;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import top.theillusivec4.culinaryconstruct.common.tag.CulinaryTags;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public class CulinaryCalculator {
    private final NonNullList<ItemStack> ingredients;
    private final NonNullList<ItemStack> solids;
    private final List<ItemStack> processed = new ArrayList<ItemStack>();
    private final ItemStack base;
    private int food;
    private float saturation;
    private int complexity;
    private List<Integer> liquidColors;

    public CulinaryCalculator(ItemStack baseIn, NonNullList<ItemStack> ingredientsIn) {
        this.base = baseIn;
        this.ingredients = ingredientsIn;
        this.solids = NonNullList.func_191196_a();
        this.liquidColors = new ArrayList<Integer>();
    }

    public ItemStack getResult() {
        int maxFood;
        OutputType type;
        ArrayList<ItemStack> process = new ArrayList<ItemStack>((Collection<ItemStack>)this.ingredients);
        this.processed.clear();
        if (CulinaryTags.BREAD.func_199685_a_((Object)this.base.func_77973_b())) {
            type = OutputType.SANDWICH;
            maxFood = (Integer)CulinaryConstructConfig.SERVER.maxFoodPerSandwich.get();
        } else if (CulinaryTags.BOWL.func_199685_a_((Object)this.base.func_77973_b())) {
            type = OutputType.BOWL;
            maxFood = Integer.MAX_VALUE;
        } else {
            return ItemStack.field_190927_a;
        }
        if (type == OutputType.SANDWICH) {
            process.add(this.base);
        }
        for (ItemStack stack : process) {
            if (stack.func_190926_b() || this.processStack(stack)) continue;
            return ItemStack.field_190927_a;
        }
        if (type == OutputType.SANDWICH && !this.liquidColors.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (this.saturation <= 0.0f || this.food <= 0) {
            return ItemStack.field_190927_a;
        }
        this.saturation /= (float)this.food;
        int count = 1;
        if (type == OutputType.SANDWICH) {
            count = (int)Math.ceil((double)this.food / (double)maxFood);
        }
        this.food = (int)Math.ceil((double)this.food / (double)count);
        int quality = MathHelper.func_76125_a((int)(this.complexity - this.getSize() / 2 + 1), (int)0, (int)4);
        this.saturation *= 1.0f + (float)(quality - 2) * 0.3f;
        ItemStack result = type == OutputType.SANDWICH ? new ItemStack((IItemProvider)CulinaryConstructRegistry.SANDWICH) : new ItemStack((IItemProvider)CulinaryConstructRegistry.FOOD_BOWL);
        CulinaryNBTHelper.setSize(result, this.getSize());
        CulinaryNBTHelper.setIngredientsList(result, this.ingredients);
        CulinaryNBTHelper.setFoodAmount(result, this.food);
        CulinaryNBTHelper.setSaturation(result, this.saturation);
        CulinaryNBTHelper.setQuality(result, quality);
        CulinaryNBTHelper.setBase(result, this.base);
        CulinaryNBTHelper.setSolids(result, this.solids);
        CulinaryNBTHelper.setSolidsSize(result, this.solids.size());
        if (!this.liquidColors.isEmpty() && type != OutputType.SANDWICH) {
            this.liquidColors.removeIf(Objects::isNull);
            CulinaryNBTHelper.setLiquids(result, this.liquidColors);
        }
        result.func_190920_e(count);
        return result;
    }

    public boolean processStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        Food food = item.func_219967_s();
        LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructAPI.getCulinaryIngredient(stack);
        int foodAmount = 0;
        float saturationAmount = 0.0f;
        boolean valid = true;
        if (culinary.isPresent()) {
            culinary.ifPresent(ingredient -> {
                if (ingredient.isLiquid()) {
                    this.liquidColors.add(ingredient.getLiquidColor());
                } else {
                    this.solids.add((Object)stack);
                }
            });
            valid = (Boolean)culinary.map(ICulinaryIngredient::isValid).orElse((Object)true);
            foodAmount = (Integer)culinary.map(ICulinaryIngredient::getFoodAmount).orElse((Object)0);
            saturationAmount = ((Float)culinary.map(ICulinaryIngredient::getSaturation).orElse((Object)Float.valueOf(0.0f))).floatValue();
        } else if (food != null) {
            foodAmount = food.func_221466_a();
            saturationAmount = food.func_221469_b();
            this.solids.add((Object)stack);
        }
        if (!valid) {
            return false;
        }
        this.food += foodAmount;
        this.saturation += saturationAmount * (float)foodAmount;
        boolean unique = true;
        for (ItemStack existing : this.processed) {
            if (existing.func_190926_b() || !ItemStack.func_77989_b((ItemStack)existing, (ItemStack)stack)) continue;
            unique = false;
            break;
        }
        if (unique) {
            ++this.complexity;
        }
        this.processed.add(stack);
        return true;
    }

    public int getSize() {
        return this.ingredients.size();
    }

    static enum OutputType {
        SANDWICH,
        BOWL;

    }
}

