/*
 * Decompiled with CFR 0.152.
 */
package me.deadlymc.damagetint;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class TintConfig {
    private static TintConfig INSTANCE;
    private final File config = new File(this.getConfigDirectory(), "damage_tint.json");
    private float health;
    private boolean dynamic;

    public void init() {
        this.health = 20.0f;
        this.dynamic = true;
        JsonObject object = new JsonObject();
        object.addProperty("health", (Number)Float.valueOf(this.health));
        object.addProperty("dynamic", Boolean.valueOf(this.dynamic));
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.getFile()));
            writer.write(object.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update() {
        try {
            File jsonFile = this.getFile();
            String jsonString = FileUtils.readFileToString((File)jsonFile, (Charset)Charsets.UTF_8);
            JsonElement jelement = new JsonParser().parse(jsonString);
            JsonObject jobject = jelement.getAsJsonObject();
            if (jobject.get("health") == null) {
                jobject.addProperty("health", (Number)Float.valueOf(20.0f));
                this.health = 20.0f;
            }
            if (jobject.get("dynamic") == null) {
                jobject.addProperty("dynamic", Boolean.valueOf(true));
                this.dynamic = true;
            }
            this.health = jobject.get("health").getAsFloat();
            this.dynamic = jobject.get("dynamic").getAsBoolean();
            String resultingJson = new Gson().toJson(jelement);
            FileUtils.writeStringToFile((File)jsonFile, (String)resultingJson, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update(float health, boolean dynamic) {
        try {
            File jsonFile = this.getFile();
            String jsonString = FileUtils.readFileToString((File)jsonFile, (Charset)Charsets.UTF_8);
            JsonElement jelement = new JsonParser().parse(jsonString);
            JsonObject jobject = jelement.getAsJsonObject();
            jobject.addProperty("health", (Number)Float.valueOf(health));
            jobject.addProperty("dynamic", Boolean.valueOf(dynamic));
            String resultingJson = new Gson().toJson(jelement);
            FileUtils.writeStringToFile((File)jsonFile, (String)resultingJson, (Charset)Charsets.UTF_8);
            this.health = health;
            this.dynamic = dynamic;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dynamic(boolean dynamic) {
        try {
            File jsonFile = this.getFile();
            String jsonString = FileUtils.readFileToString((File)jsonFile, (Charset)Charsets.UTF_8);
            JsonElement jelement = new JsonParser().parse(jsonString);
            JsonObject jobject = jelement.getAsJsonObject();
            jobject.addProperty("dynamic", Boolean.valueOf(dynamic));
            String resultingJson = new Gson().toJson(jelement);
            FileUtils.writeStringToFile((File)jsonFile, (String)resultingJson, (Charset)Charsets.UTF_8);
            this.dynamic = jobject.get("dynamic").getAsBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public float getHealth() {
        return this.health;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public File getFile() {
        return this.config;
    }

    public File getConfigDirectory() {
        File configDir = new File(Minecraft.func_71410_x().field_71412_D, "config");
        configDir.mkdir();
        return configDir;
    }

    public static TintConfig instance() {
        return INSTANCE == null ? (INSTANCE = new TintConfig()) : INSTANCE;
    }
}

