/*
 * Decompiled with CFR 0.152.
 */
package me.deadlymc.damagetint.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.deadlymc.damagetint.TintConfig;
import me.deadlymc.damagetint.commands.ClientCommandManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TintCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tint").executes(TintCommand::status)).then(Commands.func_197056_a((String)"health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).suggests((c, b) -> ISuggestionProvider.func_197008_a((String[])new String[]{"0", "10", "20"}, (SuggestionsBuilder)b)).executes(c -> TintCommand.changeThreshold(FloatArgumentType.getFloat((CommandContext)c, (String)"health"))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dynamic").executes(TintCommand::dynamic_status)).then(Commands.func_197056_a((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(c -> TintCommand.dynamic(BoolArgumentType.getBool((CommandContext)c, (String)"value")))))).then(Commands.func_197057_a((String)"reset").executes(TintCommand::reset));
        dispatcher.register(command);
    }

    private static int status(CommandContext<CommandSource> context) throws CommandSyntaxException {
        boolean dynamic = TintConfig.instance().isDynamic();
        float maxHealth = ((PlayerEntity)((CommandSource)context.getSource()).func_197027_g()).func_110138_aP();
        float thresholdHealth = TintConfig.instance().getHealth();
        ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Predefined health threshold = " + TextFormatting.RED + "" + TextFormatting.BOLD + thresholdHealth + " hp (" + thresholdHealth / 2.0f + " hearts)" + TextFormatting.GRAY + "."));
        if (dynamic) {
            ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Current health threshold = " + TextFormatting.RED + "" + TextFormatting.BOLD + maxHealth + " hp (" + maxHealth / 2.0f + " hearts)" + TextFormatting.GRAY + "."));
        }
        ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(dynamic ? TextFormatting.GRAY + "Health threshold is updating dynamically! (Ignoring predefined value)" : TextFormatting.GRAY + "Health threshold is not updating dynamically! (Using predefined value)"));
        return 0;
    }

    private static int changeThreshold(float health) {
        TintConfig.instance().update(health, false);
        ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Gradually tint screen at " + TextFormatting.RED + "" + TextFormatting.BOLD + health + " hp (" + health / 2.0f + " hearts)" + TextFormatting.GRAY + "."));
        return 0;
    }

    private static int dynamic_status(CommandContext<CommandSource> context) {
        boolean dynamic = TintConfig.instance().isDynamic();
        ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(dynamic ? TextFormatting.GRAY + "Health threshold is updating dynamically! (Ignoring predefined value)" : TextFormatting.GRAY + "Health threshold is not updating dynamically! (Using predefined value)"));
        return 0;
    }

    private static int dynamic(boolean dynamic) {
        TintConfig.instance().dynamic(dynamic);
        String msg = "";
        if (TintConfig.instance().isDynamic()) {
            msg = TextFormatting.GRAY + "Health threshold will update dynamically!";
        } else {
            float health = TintConfig.instance().getHealth();
            msg = TextFormatting.GRAY + "Health threshold will not update dynamically! Using predefined health threshold = " + TextFormatting.RED + "" + TextFormatting.BOLD + health + " hp (" + health / 2.0f + " hearts)" + TextFormatting.GRAY + ".";
        }
        ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(msg));
        return 0;
    }

    private static int reset(CommandContext<CommandSource> context) {
        TintConfig.instance().update(20.0f, true);
        ClientCommandManager.sendFeedback((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Reset all configs to default."));
        return 0;
    }
}

