/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.metamorph;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.mcreator.metamorph.DeadGuysAdditionalFeatures;
import net.mcreator.metamorph.DeadGuysAdditionalFeaturesVariables;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;

public class ElementsDeadGuysAdditionalFeatures
implements IFuelHandler,
IWorldGenerator {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityEntry>> entities = new ArrayList<Supplier<EntityEntry>>();
    public final List<Supplier<Potion>> potions = new ArrayList<Supplier<Potion>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public ElementsDeadGuysAdditionalFeatures() {
        sounds.put(new ResourceLocation("dgsaf", "chaoschaos"), new SoundEvent(new ResourceLocation("dgsaf", "chaoschaos")));
        sounds.put(new ResourceLocation("dgsaf", "nootnoot"), new SoundEvent(new ResourceLocation("dgsaf", "nootnoot")));
        sounds.put(new ResourceLocation("dgsaf", "rockdeath"), new SoundEvent(new ResourceLocation("dgsaf", "rockdeath")));
        sounds.put(new ResourceLocation("dgsaf", "rockhit"), new SoundEvent(new ResourceLocation("dgsaf", "rockhit")));
        sounds.put(new ResourceLocation("dgsaf", "rockvictory"), new SoundEvent(new ResourceLocation("dgsaf", "rockvictory")));
        sounds.put(new ResourceLocation("dgsaf", "phatnomdeath"), new SoundEvent(new ResourceLocation("dgsaf", "phatnomdeath")));
        sounds.put(new ResourceLocation("dgsaf", "phatnomhurt"), new SoundEvent(new ResourceLocation("dgsaf", "phatnomhurt")));
        sounds.put(new ResourceLocation("dgsaf", "idlephant"), new SoundEvent(new ResourceLocation("dgsaf", "idlephant")));
        sounds.put(new ResourceLocation("dgsaf", "bigdeath"), new SoundEvent(new ResourceLocation("dgsaf", "bigdeath")));
        sounds.put(new ResourceLocation("dgsaf", "bigidle"), new SoundEvent(new ResourceLocation("dgsaf", "bigidle")));
        sounds.put(new ResourceLocation("dgsaf", "hurty"), new SoundEvent(new ResourceLocation("dgsaf", "hurty")));
        sounds.put(new ResourceLocation("dgsaf", "foxmeaw"), new SoundEvent(new ResourceLocation("dgsaf", "foxmeaw")));
        sounds.put(new ResourceLocation("dgsaf", "x-xfox"), new SoundEvent(new ResourceLocation("dgsaf", "x-xfox")));
        sounds.put(new ResourceLocation("dgsaf", "sniffsniff"), new SoundEvent(new ResourceLocation("dgsaf", "sniffsniff")));
        sounds.put(new ResourceLocation("dgsaf", "pudis"), new SoundEvent(new ResourceLocation("dgsaf", "pudis")));
    }

    public void preInit(FMLPreInitializationEvent event) {
        try {
            for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ModElement.Tag.class.getName())) {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (clazz.getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(DeadGuysAdditionalFeaturesVariables.WorldSavedDataSyncMessageHandler.class, DeadGuysAdditionalFeaturesVariables.WorldSavedDataSyncMessage.class, Side.SERVER, Side.CLIENT);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator cg, IChunkProvider cp) {
        this.elements.forEach(element -> element.generateWorld(random, chunkX * 16, chunkZ * 16, world, world.field_73011_w.getDimension(), cg, cp));
    }

    public int getBurnTime(ItemStack fuel) {
        for (ModElement element : this.elements) {
            int ret = element.addFuel(fuel);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            DeadGuysAdditionalFeaturesVariables.MapVariables mapdata = DeadGuysAdditionalFeaturesVariables.MapVariables.get(event.player.field_70170_p);
            DeadGuysAdditionalFeaturesVariables.WorldVariables worlddata = DeadGuysAdditionalFeaturesVariables.WorldVariables.get(event.player.field_70170_p);
            if (mapdata != null) {
                DeadGuysAdditionalFeatures.PACKET_HANDLER.sendTo((IMessage)new DeadGuysAdditionalFeaturesVariables.WorldSavedDataSyncMessage(0, mapdata), (EntityPlayerMP)event.player);
            }
            if (worlddata != null) {
                DeadGuysAdditionalFeatures.PACKET_HANDLER.sendTo((IMessage)new DeadGuysAdditionalFeaturesVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        DeadGuysAdditionalFeaturesVariables.WorldVariables worlddata;
        if (!event.player.field_70170_p.field_72995_K && (worlddata = DeadGuysAdditionalFeaturesVariables.WorldVariables.get(event.player.field_70170_p)) != null) {
            DeadGuysAdditionalFeatures.PACKET_HANDLER.sendTo((IMessage)new DeadGuysAdditionalFeaturesVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
    }

    public <T extends IMessage, V extends IMessage> void addNetworkMessage(Class<? extends IMessageHandler<T, V>> handler, Class<T> messageClass, Side ... sides) {
        for (Side side : sides) {
            DeadGuysAdditionalFeatures.PACKET_HANDLER.registerMessage(handler, messageClass, this.messageID, side);
        }
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityEntry>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Potion>> getPotions() {
        return this.potions;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final ElementsDeadGuysAdditionalFeatures elements;
        protected final int sortid;

        public ModElement(ElementsDeadGuysAdditionalFeatures elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLInitializationEvent event) {
        }

        public void preInit(FMLPreInitializationEvent event) {
        }

        public void generateWorld(Random random, int posX, int posZ, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        public void registerModels(ModelRegistryEvent event) {
        }

        public int addFuel(ItemStack fuel) {
            return 0;
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }

    public static class GuiHandler
    implements IGuiHandler {
        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }
    }
}

