/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft;

import com.vulp.druidcraft.config.Configuration;
import com.vulp.druidcraft.network.PacketHandler;
import com.vulp.druidcraft.registry.BiomeRegistry;
import com.vulp.druidcraft.registry.ParticleRegistry;
import com.vulp.druidcraft.registry.RenderRegistry;
import com.vulp.druidcraft.registry.VanillaIntegrationRegistry;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="druidcraft")
public class Druidcraft {
    public static Druidcraft INSTANCE;
    public static final String MODID = "druidcraft";
    public static final Logger LOGGER;

    public Druidcraft() {
        INSTANCE = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Configuration.server_config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Configuration.client_config);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        bus.addListener(this::doParticleStuff);
        Configuration.loadConfig(Configuration.server_config, FMLPaths.CONFIGDIR.get().resolve("druidcraft-server.toml").toString());
        Configuration.loadConfig(Configuration.client_config, FMLPaths.CONFIGDIR.get().resolve("druidcraft-client.toml").toString());
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        event.enqueueWork(() -> {
            BiomeRegistry.registerBiomes();
            VanillaIntegrationRegistry.setup();
        });
        LOGGER.info("Setup method registered.");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderRegistry.registryRenders(event);
        LOGGER.info("Client registry method registered.");
    }

    private void doParticleStuff(ParticleFactoryRegisterEvent event) {
        ParticleRegistry.registerFactories();
        LOGGER.info("Particle registry method registered.");
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
    }
}

