/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.mojang.datafixers.util.Pair;
import com.vulp.druidcraft.api.CrateDataCarrier;
import com.vulp.druidcraft.api.CrateIndex;
import com.vulp.druidcraft.api.CrateType;
import com.vulp.druidcraft.blocks.tileentities.CrateTileEntity;
import com.vulp.druidcraft.registry.BlockRegistry;
import com.vulp.druidcraft.registry.ItemRegistry;
import com.vulp.druidcraft.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CrateBlock
extends ContainerBlock {
    public static final BooleanProperty PROPERTY_OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<CrateIndex> INDEX = EnumProperty.func_177709_a((String)"index", CrateIndex.class);
    private static final BooleanProperty ROTATED = BooleanProperty.func_177716_a((String)"rot");
    private static Random bool = new Random();

    public CrateBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(INDEX, (Comparable)((Object)CrateIndex.CRATE00_1))).func_206870_a((Property)PROPERTY_OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == ItemRegistry.crate) {
            return ActionResultType.PASS;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof CrateTileEntity && !worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((CrateTileEntity)te), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    private List<BlockPos> checkForCrates(World world, BlockPos pos) {
        ArrayList<BlockPos> shapeConfig = new ArrayList<BlockPos>();
        if (this.checkCrateBlocks(world, pos.func_177974_f(), pos.func_177968_d(), pos.func_177968_d().func_177974_f(), pos.func_177984_a(), pos.func_177984_a().func_177974_f(), pos.func_177984_a().func_177968_d(), pos.func_177984_a().func_177968_d().func_177974_f())) {
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            shapeConfig.add(pos.func_177968_d());
            shapeConfig.add(pos.func_177968_d().func_177974_f());
            shapeConfig.add(pos.func_177984_a());
            shapeConfig.add(pos.func_177984_a().func_177974_f());
            shapeConfig.add(pos.func_177984_a().func_177968_d());
            shapeConfig.add(pos.func_177984_a().func_177968_d().func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177976_e(), pos.func_177968_d().func_177976_e(), pos.func_177968_d(), pos.func_177984_a().func_177976_e(), pos.func_177984_a(), pos.func_177984_a().func_177968_d().func_177976_e(), pos.func_177984_a().func_177968_d())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177968_d().func_177976_e());
            shapeConfig.add(pos.func_177968_d());
            shapeConfig.add(pos.func_177984_a().func_177976_e());
            shapeConfig.add(pos.func_177984_a());
            shapeConfig.add(pos.func_177984_a().func_177968_d().func_177976_e());
            shapeConfig.add(pos.func_177984_a().func_177968_d());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177978_c(), pos.func_177978_c().func_177974_f(), pos.func_177974_f(), pos.func_177984_a().func_177978_c(), pos.func_177984_a().func_177978_c().func_177974_f(), pos.func_177984_a(), pos.func_177984_a().func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos.func_177978_c().func_177974_f());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            shapeConfig.add(pos.func_177984_a().func_177978_c());
            shapeConfig.add(pos.func_177984_a().func_177978_c().func_177974_f());
            shapeConfig.add(pos.func_177984_a());
            shapeConfig.add(pos.func_177984_a().func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177978_c().func_177976_e(), pos.func_177978_c(), pos.func_177976_e(), pos.func_177984_a().func_177978_c().func_177976_e(), pos.func_177984_a().func_177978_c(), pos.func_177984_a().func_177976_e(), pos.func_177984_a())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177978_c().func_177976_e());
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177984_a().func_177978_c().func_177976_e());
            shapeConfig.add(pos.func_177984_a().func_177978_c());
            shapeConfig.add(pos.func_177984_a().func_177976_e());
            shapeConfig.add(pos.func_177984_a());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b(), pos.func_177977_b().func_177974_f(), pos.func_177977_b().func_177968_d(), pos.func_177977_b().func_177968_d().func_177974_f(), pos.func_177974_f(), pos.func_177968_d(), pos.func_177968_d().func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177977_b().func_177974_f());
            shapeConfig.add(pos.func_177977_b().func_177968_d());
            shapeConfig.add(pos.func_177977_b().func_177968_d().func_177974_f());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            shapeConfig.add(pos.func_177968_d());
            shapeConfig.add(pos.func_177968_d().func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b().func_177976_e(), pos.func_177977_b(), pos.func_177977_b().func_177968_d().func_177976_e(), pos.func_177977_b().func_177968_d(), pos.func_177976_e(), pos.func_177968_d().func_177976_e(), pos.func_177968_d())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b().func_177976_e());
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177977_b().func_177968_d().func_177976_e());
            shapeConfig.add(pos.func_177977_b().func_177968_d());
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177968_d().func_177976_e());
            shapeConfig.add(pos.func_177968_d());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b().func_177978_c(), pos.func_177977_b().func_177978_c().func_177974_f(), pos.func_177977_b(), pos.func_177977_b().func_177974_f(), pos.func_177978_c(), pos.func_177978_c().func_177974_f(), pos.func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b().func_177978_c());
            shapeConfig.add(pos.func_177977_b().func_177978_c().func_177974_f());
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177977_b().func_177974_f());
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos.func_177978_c().func_177974_f());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b().func_177978_c().func_177976_e(), pos.func_177977_b().func_177978_c(), pos.func_177977_b().func_177976_e(), pos.func_177977_b(), pos.func_177978_c().func_177976_e(), pos.func_177978_c(), pos.func_177976_e())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b().func_177978_c().func_177976_e());
            shapeConfig.add(pos.func_177977_b().func_177978_c());
            shapeConfig.add(pos.func_177977_b().func_177976_e());
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177978_c().func_177976_e());
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.OCTO, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177968_d(), pos.func_177984_a(), pos.func_177984_a().func_177968_d())) {
            shapeConfig.clear();
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177968_d());
            shapeConfig.add(pos.func_177984_a());
            shapeConfig.add(pos.func_177984_a().func_177968_d());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_X, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177978_c(), pos.func_177978_c().func_177984_a(), pos.func_177984_a())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177984_a().func_177978_c());
            shapeConfig.add(pos.func_177984_a());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_X, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b(), pos.func_177977_b().func_177968_d(), pos.func_177968_d())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177977_b().func_177968_d());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177968_d());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_X, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b().func_177978_c(), pos.func_177977_b(), pos.func_177978_c())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b().func_177978_c());
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_X, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177974_f(), pos.func_177968_d(), pos.func_177968_d().func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            shapeConfig.add(pos.func_177968_d());
            shapeConfig.add(pos.func_177968_d().func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Y, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177976_e(), pos.func_177968_d(), pos.func_177968_d().func_177976_e())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177968_d().func_177976_e());
            shapeConfig.add(pos.func_177968_d());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Y, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177978_c(), pos.func_177974_f(), pos.func_177978_c().func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos.func_177978_c().func_177974_f());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Y, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177978_c(), pos.func_177976_e(), pos.func_177978_c().func_177976_e())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177978_c().func_177976_e());
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Y, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177974_f(), pos.func_177984_a(), pos.func_177984_a().func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            shapeConfig.add(pos.func_177984_a());
            shapeConfig.add(pos.func_177984_a().func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Z, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177976_e(), pos.func_177984_a().func_177976_e(), pos.func_177984_a())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177984_a().func_177976_e());
            shapeConfig.add(pos.func_177984_a());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Z, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b(), pos.func_177977_b().func_177974_f(), pos.func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177977_b().func_177974_f());
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Z, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b().func_177976_e(), pos.func_177977_b(), pos.func_177976_e())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b().func_177976_e());
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.QUAD_Z, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177974_f())) {
            shapeConfig.clear();
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177974_f());
            if (this.checkIllegalCrates(world, pos, CrateType.DOUBLE_X, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177976_e())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177976_e());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.DOUBLE_X, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177984_a())) {
            shapeConfig.clear();
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177984_a());
            if (this.checkIllegalCrates(world, pos, CrateType.DOUBLE_Y, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177977_b())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177977_b());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.DOUBLE_Y, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177968_d())) {
            shapeConfig.clear();
            shapeConfig.add(pos);
            shapeConfig.add(pos.func_177968_d());
            if (this.checkIllegalCrates(world, pos, CrateType.DOUBLE_Z, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        if (this.checkCrateBlocks(world, pos.func_177978_c())) {
            shapeConfig.clear();
            shapeConfig.add(pos.func_177978_c());
            shapeConfig.add(pos);
            if (this.checkIllegalCrates(world, pos, CrateType.DOUBLE_Z, shapeConfig) && this.checkSides(world, shapeConfig)) {
                return shapeConfig;
            }
        }
        shapeConfig.clear();
        shapeConfig.add(pos);
        return shapeConfig;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CrateTileEntity) {
            ((CrateTileEntity)tileentity).crateTick();
        }
    }

    public static List<BlockPos> getBlockPositions(World world, BlockPos pos) {
        ArrayList<BlockPos> config = new ArrayList<BlockPos>();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != BlockRegistry.crate) {
            return config;
        }
        CrateType type = CrateType.SINGLE;
        int num = ((CrateIndex)((Object)state.func_177229_b(INDEX))).getPosNumber();
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.DOUBLE_X) {
            type = CrateType.DOUBLE_X;
        }
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.DOUBLE_Y) {
            type = CrateType.DOUBLE_Y;
        }
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.DOUBLE_Z) {
            type = CrateType.DOUBLE_Z;
        }
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.QUAD_X) {
            type = CrateType.QUAD_X;
        }
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.QUAD_Y) {
            type = CrateType.QUAD_Y;
        }
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.QUAD_Z) {
            type = CrateType.QUAD_Z;
        }
        if (((CrateIndex)((Object)world.func_180495_p(pos).func_177229_b(INDEX))).getType() == CrateType.OCTO) {
            type = CrateType.OCTO;
        }
        if (type == CrateType.OCTO) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177974_f());
                config.add(pos.func_177968_d());
                config.add(pos.func_177974_f().func_177968_d());
                config.add(pos.func_177984_a());
                config.add(pos.func_177974_f().func_177984_a());
                config.add(pos.func_177968_d().func_177984_a());
                config.add(pos.func_177974_f().func_177968_d().func_177984_a());
            }
            if (num == 2) {
                config.add(pos.func_177976_e());
                config.add(pos);
                config.add(pos.func_177968_d().func_177976_e());
                config.add(pos.func_177968_d());
                config.add(pos.func_177976_e().func_177984_a());
                config.add(pos.func_177984_a());
                config.add(pos.func_177968_d().func_177976_e().func_177984_a());
                config.add(pos.func_177968_d().func_177984_a());
            }
            if (num == 3) {
                config.add(pos.func_177978_c());
                config.add(pos.func_177978_c().func_177974_f());
                config.add(pos);
                config.add(pos.func_177974_f());
                config.add(pos.func_177978_c().func_177984_a());
                config.add(pos.func_177978_c().func_177974_f().func_177984_a());
                config.add(pos.func_177984_a());
                config.add(pos.func_177974_f().func_177984_a());
            }
            if (num == 4) {
                config.add(pos.func_177978_c().func_177976_e());
                config.add(pos.func_177978_c());
                config.add(pos.func_177976_e());
                config.add(pos);
                config.add(pos.func_177978_c().func_177976_e().func_177984_a());
                config.add(pos.func_177978_c().func_177984_a());
                config.add(pos.func_177976_e().func_177984_a());
                config.add(pos.func_177984_a());
            }
            if (num == 5) {
                config.add(pos.func_177977_b());
                config.add(pos.func_177974_f().func_177977_b());
                config.add(pos.func_177968_d().func_177977_b());
                config.add(pos.func_177974_f().func_177968_d().func_177977_b());
                config.add(pos);
                config.add(pos.func_177974_f());
                config.add(pos.func_177968_d());
                config.add(pos.func_177974_f().func_177968_d());
            }
            if (num == 6) {
                config.add(pos.func_177976_e().func_177977_b());
                config.add(pos.func_177977_b());
                config.add(pos.func_177968_d().func_177976_e().func_177977_b());
                config.add(pos.func_177968_d().func_177977_b());
                config.add(pos.func_177976_e());
                config.add(pos);
                config.add(pos.func_177968_d().func_177976_e());
                config.add(pos.func_177968_d());
            }
            if (num == 7) {
                config.add(pos.func_177978_c().func_177977_b());
                config.add(pos.func_177978_c().func_177974_f().func_177977_b());
                config.add(pos.func_177977_b());
                config.add(pos.func_177974_f().func_177977_b());
                config.add(pos.func_177978_c());
                config.add(pos.func_177978_c().func_177974_f());
                config.add(pos);
                config.add(pos.func_177974_f());
            }
            if (num == 8) {
                config.add(pos.func_177978_c().func_177976_e().func_177977_b());
                config.add(pos.func_177978_c().func_177977_b());
                config.add(pos.func_177976_e().func_177977_b());
                config.add(pos.func_177977_b());
                config.add(pos.func_177978_c().func_177976_e());
                config.add(pos.func_177978_c());
                config.add(pos.func_177976_e());
                config.add(pos);
            }
        }
        if (type == CrateType.QUAD_X) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177968_d());
                config.add(pos.func_177984_a());
                config.add(pos.func_177984_a().func_177968_d());
            }
            if (num == 2) {
                config.add(pos.func_177978_c());
                config.add(pos);
                config.add(pos.func_177978_c().func_177984_a());
                config.add(pos.func_177984_a());
            }
            if (num == 3) {
                config.add(pos.func_177977_b());
                config.add(pos.func_177977_b().func_177968_d());
                config.add(pos);
                config.add(pos.func_177968_d());
            }
            if (num == 4) {
                config.add(pos.func_177977_b().func_177978_c());
                config.add(pos.func_177977_b());
                config.add(pos.func_177978_c());
                config.add(pos);
            }
        }
        if (type == CrateType.QUAD_Y) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177974_f());
                config.add(pos.func_177968_d());
                config.add(pos.func_177968_d().func_177974_f());
            }
            if (num == 2) {
                config.add(pos.func_177976_e());
                config.add(pos);
                config.add(pos.func_177976_e().func_177968_d());
                config.add(pos.func_177968_d());
            }
            if (num == 3) {
                config.add(pos.func_177978_c());
                config.add(pos.func_177978_c().func_177974_f());
                config.add(pos);
                config.add(pos.func_177974_f());
            }
            if (num == 4) {
                config.add(pos.func_177978_c().func_177976_e());
                config.add(pos.func_177978_c());
                config.add(pos.func_177976_e());
                config.add(pos);
            }
        }
        if (type == CrateType.QUAD_Z) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177974_f());
                config.add(pos.func_177984_a());
                config.add(pos.func_177984_a().func_177974_f());
            }
            if (num == 2) {
                config.add(pos.func_177976_e());
                config.add(pos);
                config.add(pos.func_177976_e().func_177984_a());
                config.add(pos.func_177984_a());
            }
            if (num == 3) {
                config.add(pos.func_177977_b());
                config.add(pos.func_177977_b().func_177974_f());
                config.add(pos);
                config.add(pos.func_177974_f());
            }
            if (num == 4) {
                config.add(pos.func_177977_b().func_177976_e());
                config.add(pos.func_177977_b());
                config.add(pos.func_177976_e());
                config.add(pos);
            }
        }
        if (type == CrateType.DOUBLE_X) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177974_f());
            }
            if (num == 2) {
                config.add(pos.func_177976_e());
                config.add(pos);
            }
        }
        if (type == CrateType.DOUBLE_Y) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177984_a());
            }
            if (num == 2) {
                config.add(pos.func_177977_b());
                config.add(pos);
            }
        }
        if (type == CrateType.DOUBLE_Z) {
            if (num == 1) {
                config.add(pos);
                config.add(pos.func_177968_d());
            }
            if (num == 2) {
                config.add(pos.func_177978_c());
                config.add(pos);
            }
        }
        if (type == CrateType.SINGLE) {
            config.add(pos);
        }
        return config;
    }

    @Deprecated
    public static boolean checkBlockPositions(World world, BlockPos pos, CrateType type, List<BlockPos> posList) {
        for (int i = 1; i > posList.size() + 1; ++i) {
            if (!(type != CrateType.OCTO || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.OCTO)) {
                return false;
            }
            if (!(type != CrateType.QUAD_X || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.QUAD_X)) {
                return false;
            }
            if (!(type != CrateType.QUAD_Y || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.QUAD_Y)) {
                return false;
            }
            if (!(type != CrateType.QUAD_Z || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.QUAD_Z)) {
                return false;
            }
            if (!(type != CrateType.DOUBLE_X || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.DOUBLE_X)) {
                return false;
            }
            if (!(type != CrateType.DOUBLE_Y || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.DOUBLE_Y)) {
                return false;
            }
            if (!(type != CrateType.DOUBLE_Z || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.DOUBLE_Z)) {
                return false;
            }
            if (type != CrateType.SINGLE || world.func_180495_p(posList.get(i)).func_177230_c() instanceof CrateBlock && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getPosNumber() == i && ((CrateIndex)((Object)world.func_180495_p(posList.get(i)).func_177229_b(INDEX))).getType() == CrateType.SINGLE) continue;
            return false;
        }
        return false;
    }

    private boolean checkIllegalCrates(World world, BlockPos pos, CrateType type, List<BlockPos> blockPosList) {
        if (type == CrateType.DOUBLE_X || type == CrateType.DOUBLE_Y || type == CrateType.DOUBLE_Z) {
            for (BlockPos blockPos : blockPosList) {
                if (blockPos == pos || ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() == CrateType.SINGLE) continue;
                return false;
            }
        }
        if (type == CrateType.OCTO) {
            for (BlockPos blockPos : blockPosList) {
                if (blockPos == pos || ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.OCTO) continue;
                return false;
            }
        }
        if (type == CrateType.QUAD_X) {
            for (BlockPos blockPos : blockPosList) {
                if (blockPos == pos || ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.DOUBLE_X && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_X && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_Y && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_Z && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.OCTO) continue;
                return false;
            }
        }
        if (type == CrateType.QUAD_Y) {
            for (BlockPos blockPos : blockPosList) {
                if (blockPos == pos || ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.DOUBLE_Y && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_X && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_Y && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_Z && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.OCTO) continue;
                return false;
            }
        }
        if (type == CrateType.QUAD_Z) {
            for (BlockPos blockPos : blockPosList) {
                if (blockPos == pos || ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.DOUBLE_Z && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_X && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_Y && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.QUAD_Z && ((CrateIndex)((Object)world.func_180495_p(blockPos).func_177229_b(INDEX))).getType() != CrateType.OCTO) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkSides(World world, List<BlockPos> blockPosList) {
        for (int i = 0; i < blockPosList.size(); ++i) {
            CrateType type = this.getCrateType(blockPosList);
            int num = i + 1;
            if (!(type != CrateType.OCTO || num != 1 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 2 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 3 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 4 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 5 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 6 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 7 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown())) {
                return false;
            }
            if (!(type != CrateType.OCTO || num != 8 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown())) {
                return false;
            }
            if (!(type != CrateType.QUAD_X || num != 1 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp())) {
                return false;
            }
            if (!(type != CrateType.QUAD_X || num != 2 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp())) {
                return false;
            }
            if (!(type != CrateType.QUAD_X || num != 3 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown())) {
                return false;
            }
            if (!(type != CrateType.QUAD_X || num != 4 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Y || num != 1 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Y || num != 2 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Y || num != 3 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Y || num != 4 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Z || num != 1 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Z || num != 2 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Z || num != 3 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast())) {
                return false;
            }
            if (!(type != CrateType.QUAD_Z || num != 4 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown() && ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest())) {
                return false;
            }
            if (type == CrateType.DOUBLE_X && num == 1 && !((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isEast()) {
                return false;
            }
            if (type == CrateType.DOUBLE_X && num == 2 && !((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isWest()) {
                return false;
            }
            if (type == CrateType.DOUBLE_Y && num == 1 && !((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isUp()) {
                return false;
            }
            if (type == CrateType.DOUBLE_Y && num == 2 && !((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isDown()) {
                return false;
            }
            if (type == CrateType.DOUBLE_Z && num == 1 && !((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isSouth()) {
                return false;
            }
            if (type != CrateType.DOUBLE_Z || num != 2 || ((CrateIndex)((Object)world.func_180495_p(blockPosList.get(i)).func_177229_b(INDEX))).isNorth()) continue;
            return false;
        }
        return true;
    }

    private boolean checkCrateBlocks(World world, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            if (world.func_180495_p(pos).func_177230_c() instanceof CrateBlock) continue;
            return false;
        }
        return true;
    }

    private boolean rotateCrate(BlockPos pos) {
        bool.setSeed(pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p());
        bool.nextBoolean();
        return bool.nextBoolean();
    }

    private CrateType getCrateType(List<BlockPos> blockPosList) {
        switch (blockPosList.size()) {
            case 1: {
                return CrateType.SINGLE;
            }
            case 2: {
                BlockPos pos1_2 = blockPosList.get(0);
                BlockPos pos2_2 = blockPosList.get(1);
                if (pos1_2.func_177958_n() != pos2_2.func_177958_n()) {
                    return CrateType.DOUBLE_X;
                }
                if (pos1_2.func_177956_o() != pos2_2.func_177956_o()) {
                    return CrateType.DOUBLE_Y;
                }
                if (pos1_2.func_177952_p() != pos2_2.func_177952_p()) {
                    return CrateType.DOUBLE_Z;
                }
            }
            case 4: {
                BlockPos pos1_4 = blockPosList.get(0);
                BlockPos pos2_4 = blockPosList.get(1);
                BlockPos pos3_4 = blockPosList.get(2);
                BlockPos pos4_4 = blockPosList.get(3);
                if (pos1_4.func_177958_n() == pos2_4.func_177958_n() && pos3_4.func_177958_n() == pos4_4.func_177958_n() && pos1_4.func_177958_n() == pos3_4.func_177958_n()) {
                    return CrateType.QUAD_X;
                }
                if (pos1_4.func_177956_o() == pos2_4.func_177956_o() && pos3_4.func_177956_o() == pos4_4.func_177956_o() && pos1_4.func_177956_o() == pos3_4.func_177956_o()) {
                    return CrateType.QUAD_Y;
                }
                if (pos1_4.func_177952_p() == pos2_4.func_177952_p() && pos3_4.func_177952_p() == pos4_4.func_177952_p() && pos1_4.func_177952_p() == pos3_4.func_177952_p()) {
                    return CrateType.QUAD_Z;
                }
            }
            case 8: {
                return CrateType.OCTO;
            }
        }
        return null;
    }

    private List<CrateDataCarrier> calculateSides(List<BlockPos> blockPosList) {
        ArrayList<CrateDataCarrier> crateDataList = new ArrayList<CrateDataCarrier>();
        for (int i = 0; i < blockPosList.size(); ++i) {
            CrateType type = this.getCrateType(blockPosList);
            int num = i + 1;
            if (type == CrateType.OCTO && num == 1) {
                crateDataList.add(new CrateDataCarrier(false, true, true, false, true, false));
            }
            if (type == CrateType.OCTO && num == 2) {
                crateDataList.add(new CrateDataCarrier(false, false, true, true, true, false));
            }
            if (type == CrateType.OCTO && num == 3) {
                crateDataList.add(new CrateDataCarrier(true, true, false, false, true, false));
            }
            if (type == CrateType.OCTO && num == 4) {
                crateDataList.add(new CrateDataCarrier(true, false, false, true, true, false));
            }
            if (type == CrateType.OCTO && num == 5) {
                crateDataList.add(new CrateDataCarrier(false, true, true, false, false, true));
            }
            if (type == CrateType.OCTO && num == 6) {
                crateDataList.add(new CrateDataCarrier(false, false, true, true, false, true));
            }
            if (type == CrateType.OCTO && num == 7) {
                crateDataList.add(new CrateDataCarrier(true, true, false, false, false, true));
            }
            if (type == CrateType.OCTO && num == 8) {
                crateDataList.add(new CrateDataCarrier(true, false, false, true, false, true));
            }
            if (type == CrateType.QUAD_X && num == 1) {
                crateDataList.add(new CrateDataCarrier(false, true, true, true, true, false));
            }
            if (type == CrateType.QUAD_X && num == 2) {
                crateDataList.add(new CrateDataCarrier(true, true, false, true, true, false));
            }
            if (type == CrateType.QUAD_X && num == 3) {
                crateDataList.add(new CrateDataCarrier(false, true, true, true, false, true));
            }
            if (type == CrateType.QUAD_X && num == 4) {
                crateDataList.add(new CrateDataCarrier(true, true, false, true, false, true));
            }
            if (type == CrateType.QUAD_Y && num == 1) {
                crateDataList.add(new CrateDataCarrier(false, true, true, false, true, true));
            }
            if (type == CrateType.QUAD_Y && num == 2) {
                crateDataList.add(new CrateDataCarrier(false, false, true, true, true, true));
            }
            if (type == CrateType.QUAD_Y && num == 3) {
                crateDataList.add(new CrateDataCarrier(true, true, false, false, true, true));
            }
            if (type == CrateType.QUAD_Y && num == 4) {
                crateDataList.add(new CrateDataCarrier(true, false, false, true, true, true));
            }
            if (type == CrateType.QUAD_Z && num == 1) {
                crateDataList.add(new CrateDataCarrier(true, true, true, false, true, false));
            }
            if (type == CrateType.QUAD_Z && num == 2) {
                crateDataList.add(new CrateDataCarrier(true, false, true, true, true, false));
            }
            if (type == CrateType.QUAD_Z && num == 3) {
                crateDataList.add(new CrateDataCarrier(true, true, true, false, false, true));
            }
            if (type == CrateType.QUAD_Z && num == 4) {
                crateDataList.add(new CrateDataCarrier(true, false, true, true, false, true));
            }
            if (type == CrateType.DOUBLE_X && num == 1) {
                crateDataList.add(new CrateDataCarrier(true, true, true, false, true, true));
            }
            if (type == CrateType.DOUBLE_X && num == 2) {
                crateDataList.add(new CrateDataCarrier(true, false, true, true, true, true));
            }
            if (type == CrateType.DOUBLE_Y && num == 1) {
                crateDataList.add(new CrateDataCarrier(true, true, true, true, true, false));
            }
            if (type == CrateType.DOUBLE_Y && num == 2) {
                crateDataList.add(new CrateDataCarrier(true, true, true, true, false, true));
            }
            if (type == CrateType.DOUBLE_Z && num == 1) {
                crateDataList.add(new CrateDataCarrier(false, true, true, true, true, true));
            }
            if (type == CrateType.DOUBLE_Z && num == 2) {
                crateDataList.add(new CrateDataCarrier(true, true, false, true, true, true));
            }
            if (type != CrateType.SINGLE) continue;
            crateDataList.add(new CrateDataCarrier(true, true, true, true, true, true));
        }
        return crateDataList;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{INDEX, PROPERTY_OPEN, ROTATED});
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CrateTileEntity) {
                ItemStackHandler inventory = ((CrateTileEntity)tileentity).getInventory();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return null;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CrateTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof CrateTileEntity) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
            if (handler == null) {
                return 0;
            }
            return ItemUtil.calcRedstoneFromItemHandler(handler);
        }
        return 0;
    }

    private List<Boolean> checkMissingCrates(World world, List<BlockPos> neighborList) {
        ArrayList<Boolean> missingList = new ArrayList<Boolean>();
        for (BlockPos blockPos : neighborList) {
            missingList.add(world.func_180495_p(blockPos).func_177230_c() instanceof CrateBlock);
        }
        return missingList;
    }

    private Pair<List<BlockPos>, List<Boolean>> updateCrateShapeHelper(List<BlockPos> neighborList, List<Boolean> missingList, int num1, int num2, int num3, int num4) {
        ArrayList<BlockPos> newNeighborList = new ArrayList<BlockPos>();
        if (missingList.get(num1).booleanValue() && missingList.get(num2).booleanValue() && missingList.get(num3).booleanValue() && missingList.get(num4).booleanValue()) {
            newNeighborList.add(neighborList.get(num1));
            newNeighborList.add(neighborList.get(num2));
            newNeighborList.add(neighborList.get(num3));
            newNeighborList.add(neighborList.get(num4));
            missingList.set(num1, false);
            missingList.set(num2, false);
            missingList.set(num3, false);
            missingList.set(num4, false);
        }
        return new Pair(newNeighborList, missingList);
    }

    private Pair<List<BlockPos>, List<Boolean>> updateCrateShapeHelper(List<BlockPos> neighborList, List<Boolean> missingList, int num1, int num2) {
        ArrayList<BlockPos> newNeighborList = new ArrayList<BlockPos>();
        if (missingList.get(num1).booleanValue() && missingList.get(num2).booleanValue()) {
            newNeighborList.add(neighborList.get(num1));
            newNeighborList.add(neighborList.get(num2));
            missingList.set(num1, false);
            missingList.set(num2, false);
        }
        return new Pair(newNeighborList, missingList);
    }

    private List<List<BlockPos>> updateCrateShape(List<BlockPos> neighborList, List<Boolean> missingList) {
        Pair<List<BlockPos>, List<Boolean>> try4;
        Pair<List<BlockPos>, List<Boolean>> try3;
        Pair<List<BlockPos>, List<Boolean>> try2;
        Pair<List<BlockPos>, List<Boolean>> try1;
        CrateType type = this.getCrateType(neighborList);
        ArrayList<List<BlockPos>> cratesList = new ArrayList<List<BlockPos>>();
        if (type == CrateType.OCTO) {
            Pair<List<BlockPos>, List<Boolean>> try18;
            Pair<List<BlockPos>, List<Boolean>> try17;
            Pair<List<BlockPos>, List<Boolean>> try16;
            Pair<List<BlockPos>, List<Boolean>> try15;
            Pair<List<BlockPos>, List<Boolean>> try14;
            Pair<List<BlockPos>, List<Boolean>> try13;
            Pair<List<BlockPos>, List<Boolean>> try12;
            Pair<List<BlockPos>, List<Boolean>> try11;
            Pair<List<BlockPos>, List<Boolean>> try10;
            Pair<List<BlockPos>, List<Boolean>> try9;
            Pair<List<BlockPos>, List<Boolean>> try8;
            Pair<List<BlockPos>, List<Boolean>> try7;
            Pair<List<BlockPos>, List<Boolean>> try6;
            Pair<List<BlockPos>, List<Boolean>> try5;
            try1 = this.updateCrateShapeHelper(neighborList, missingList, 0, 1, 2, 3);
            if (!((List)try1.getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try1.getFirst());
                missingList = (List)try1.getSecond();
            }
            if (!((List)(try2 = this.updateCrateShapeHelper(neighborList, missingList, 4, 5, 6, 7)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try2.getFirst());
                missingList = (List)try2.getSecond();
            }
            if (!((List)(try3 = this.updateCrateShapeHelper(neighborList, missingList, 0, 2, 4, 6)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try3.getFirst());
                missingList = (List)try3.getSecond();
            }
            if (!((List)(try4 = this.updateCrateShapeHelper(neighborList, missingList, 1, 3, 5, 7)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try4.getFirst());
                missingList = (List)try4.getSecond();
            }
            if (!((List)(try5 = this.updateCrateShapeHelper(neighborList, missingList, 0, 1, 4, 5)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try5.getFirst());
                missingList = (List)try5.getSecond();
            }
            if (!((List)(try6 = this.updateCrateShapeHelper(neighborList, missingList, 2, 3, 6, 7)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try6.getFirst());
                missingList = (List)try6.getSecond();
            }
            if (!((List)(try7 = this.updateCrateShapeHelper(neighborList, missingList, 0, 1)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try7.getFirst());
                missingList = (List)try7.getSecond();
            }
            if (!((List)(try8 = this.updateCrateShapeHelper(neighborList, missingList, 2, 3)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try8.getFirst());
                missingList = (List)try8.getSecond();
            }
            if (!((List)(try9 = this.updateCrateShapeHelper(neighborList, missingList, 4, 5)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try9.getFirst());
                missingList = (List)try9.getSecond();
            }
            if (!((List)(try10 = this.updateCrateShapeHelper(neighborList, missingList, 6, 7)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try10.getFirst());
                missingList = (List)try10.getSecond();
            }
            if (!((List)(try11 = this.updateCrateShapeHelper(neighborList, missingList, 0, 2)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try11.getFirst());
                missingList = (List)try11.getSecond();
            }
            if (!((List)(try12 = this.updateCrateShapeHelper(neighborList, missingList, 1, 3)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try12.getFirst());
                missingList = (List)try12.getSecond();
            }
            if (!((List)(try13 = this.updateCrateShapeHelper(neighborList, missingList, 4, 6)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try13.getFirst());
                missingList = (List)try13.getSecond();
            }
            if (!((List)(try14 = this.updateCrateShapeHelper(neighborList, missingList, 5, 7)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try14.getFirst());
                missingList = (List)try14.getSecond();
            }
            if (!((List)(try15 = this.updateCrateShapeHelper(neighborList, missingList, 0, 4)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try15.getFirst());
                missingList = (List)try15.getSecond();
            }
            if (!((List)(try16 = this.updateCrateShapeHelper(neighborList, missingList, 1, 5)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try16.getFirst());
                missingList = (List)try16.getSecond();
            }
            if (!((List)(try17 = this.updateCrateShapeHelper(neighborList, missingList, 2, 6)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try17.getFirst());
                missingList = (List)try17.getSecond();
            }
            if (!((List)(try18 = this.updateCrateShapeHelper(neighborList, missingList, 3, 7)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try18.getFirst());
                missingList = (List)try18.getSecond();
            }
        }
        if (type == CrateType.QUAD_X || type == CrateType.QUAD_Y || type == CrateType.QUAD_Z) {
            try1 = this.updateCrateShapeHelper(neighborList, missingList, 0, 1);
            if (!((List)try1.getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try1.getFirst());
                missingList = (List)try1.getSecond();
            }
            if (!((List)(try2 = this.updateCrateShapeHelper(neighborList, missingList, 2, 3)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try2.getFirst());
                missingList = (List)try2.getSecond();
            }
            if (!((List)(try3 = this.updateCrateShapeHelper(neighborList, missingList, 0, 2)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try3.getFirst());
                missingList = (List)try3.getSecond();
            }
            if (!((List)(try4 = this.updateCrateShapeHelper(neighborList, missingList, 1, 3)).getFirst()).isEmpty()) {
                cratesList.add((List<BlockPos>)try4.getFirst());
                missingList = (List)try4.getSecond();
            }
        }
        for (int i = 0; i < missingList.size(); ++i) {
            if (!missingList.get(i).booleanValue()) continue;
            ArrayList<BlockPos> singleCrate = new ArrayList<BlockPos>();
            singleCrate.add(neighborList.get(i));
            cratesList.add(singleCrate);
        }
        return cratesList;
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        World world = (World)worldIn;
        List<BlockPos> neighborList = CrateBlock.getBlockPositions(world, currentPos);
        if (neighborList.isEmpty()) {
            return stateIn;
        }
        List<Boolean> missingList = this.checkMissingCrates(world, neighborList);
        if (missingList.contains(false)) {
            List<List<BlockPos>> cratesList = this.updateCrateShape(neighborList, missingList);
            for (List<BlockPos> blockPos : cratesList) {
                List<CrateDataCarrier> cardinalData = this.calculateSides(blockPos);
                for (int j = 0; j < cardinalData.size(); ++j) {
                    boolean rotate = this.rotateCrate(blockPos.get(0));
                    CrateIndex index = CrateIndex.matchCrateIndex(this.getCrateType(blockPos), j + 1, cardinalData.get(j).isNorth(), cardinalData.get(j).isSouth(), cardinalData.get(j).isEast(), cardinalData.get(j).isWest(), cardinalData.get(j).isUp(), cardinalData.get(j).isDown());
                    world.func_175656_a(blockPos.get(j), (BlockState)((BlockState)this.func_176223_P().func_206870_a(INDEX, (Comparable)((Object)index))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(rotate)));
                    if (currentPos != blockPos.get(j)) continue;
                    return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(INDEX, (Comparable)((Object)index))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(rotate))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(rotate));
                }
            }
        }
        return stateIn;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (placer != null && !placer.getEntity().func_225608_bj_()) {
            List<BlockPos> positionList = this.checkForCrates(world, pos);
            boolean rotate = this.rotateCrate(positionList.get(0));
            List<CrateDataCarrier> cardinalList = this.calculateSides(positionList);
            for (int i = 0; i < positionList.size(); ++i) {
                CrateIndex index = CrateIndex.matchCrateIndex(this.getCrateType(positionList), i + 1, cardinalList.get(i).isNorth(), cardinalList.get(i).isSouth(), cardinalList.get(i).isEast(), cardinalList.get(i).isWest(), cardinalList.get(i).isUp(), cardinalList.get(i).isDown());
                world.func_175656_a(positionList.get(i), (BlockState)((BlockState)state.func_206870_a(INDEX, (Comparable)((Object)index))).func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(rotate)));
            }
        }
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof CrateTileEntity) {
            ((CrateTileEntity)tileentity).setDisplayName(stack.func_200301_q());
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean rotate = this.rotateCrate(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)ROTATED, (Comparable)Boolean.valueOf(rotate));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("block.druidcraft.hold_shift").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("block.druidcraft.crate.description1").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }
}

