/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.vulp.druidcraft.api.CropLifeStageType;
import com.vulp.druidcraft.blocks.DynamicCropBlock;
import com.vulp.druidcraft.blocks.ElderLeavesBlock;
import com.vulp.druidcraft.registry.BlockRegistry;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class ElderFruitBlock
extends DynamicCropBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty MID_BERRY = BooleanProperty.func_177716_a((String)"mid_berry");
    public static final EnumProperty<CropLifeStageType> LIFE_STAGE = EnumProperty.func_177709_a((String)"life_stage", CropLifeStageType.class);

    public ElderFruitBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.func_185524_e(), (Comparable)Integer.valueOf(0))).func_206870_a(LIFE_STAGE, (Comparable)((Object)CropLifeStageType.FLOWER))).func_206870_a((Property)MID_BERRY, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public IntegerProperty func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 3;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)Items.field_190931_a);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        Vector3d vec3d = this.getCustomOffset(state, worldIn, pos);
        if (state.func_177229_b((Property)FACING) == Direction.UP) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)Block.func_208617_a((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        }
        if (state.func_177229_b((Property)FACING) == Direction.DOWN) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0));
        }
        if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0));
        }
        if (state.func_177229_b((Property)FACING) == Direction.EAST) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)Block.func_208617_a((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        }
        if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0));
        }
        if (state.func_177229_b((Property)FACING) == Direction.WEST) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0));
        }
        return voxelshape.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return super.func_176218_Q();
    }

    public Vector3d getCustomOffset(BlockState state, IBlockReader worldIn, BlockPos pos) {
        long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return new Vector3d(state.func_177229_b((Property)FACING) != Direction.EAST && state.func_177229_b((Property)FACING) != Direction.WEST ? ((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5 : 0.0, state.func_177229_b((Property)FACING) != Direction.UP && state.func_177229_b((Property)FACING) != Direction.DOWN ? ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 0.5) * 0.5 : 0.0, state.func_177229_b((Property)FACING) != Direction.NORTH && state.func_177229_b((Property)FACING) != Direction.SOUTH ? ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5 : 0.0);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
            if (direction == Direction.UP) {
                blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP);
            }
            if (direction == Direction.DOWN) {
                blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN);
            }
            if (direction == Direction.NORTH) {
                blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (direction == Direction.SOUTH) {
                blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.SOUTH);
            }
            if (direction == Direction.EAST) {
                blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.EAST);
            }
            if (direction == Direction.WEST) {
                blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.WEST);
            }
            if (!(context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() instanceof ElderLeavesBlock)) continue;
            return blockstate;
        }
        return null;
    }

    protected IItemProvider func_199772_f() {
        return ItemRegistry.elderberries;
    }

    public boolean isGrowable(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            return worldIn.func_180495_p(pos).func_177229_b(LIFE_STAGE) == CropLifeStageType.FLOWER || (Boolean)worldIn.func_180495_p(pos).func_177229_b((Property)MID_BERRY) != false;
        }
        return false;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(8) == 0 && CropLifeStageType.checkCropLife((World)worldIn) == CropLifeStageType.NONE) {
            worldIn.func_175655_b(pos, false);
            if (worldIn.field_73012_v.nextInt(7) == 0) {
                this.createLeafLayer(worldIn, state, pos, random);
            }
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && this.isGrowable((World)worldIn, pos)) {
            int i = this.func_185527_x(state);
            float f = ElderFruitBlock.getGrowthChance((Block)this, (IBlockReader)worldIn, pos);
            if (i < this.func_185526_g()) {
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)));
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            } else if ((CropLifeStageType.checkCropLife((World)worldIn) == CropLifeStageType.BERRY && state.func_177229_b(LIFE_STAGE) != CropLifeStageType.BERRY || ((Boolean)state.func_177229_b((Property)MID_BERRY)).booleanValue()) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0) && i == this.func_185526_g()) {
                if (state.func_177229_b(LIFE_STAGE) == CropLifeStageType.BERRY && ((Boolean)state.func_177229_b((Property)MID_BERRY)).booleanValue()) {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)MID_BERRY, (Comparable)Boolean.valueOf(false)));
                } else if (state.func_177229_b(LIFE_STAGE) != CropLifeStageType.BERRY) {
                    worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)MID_BERRY, (Comparable)Boolean.valueOf(true))).func_206870_a(LIFE_STAGE, (Comparable)((Object)CropLifeStageType.BERRY)));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public void createLeafLayer(ServerWorld world, BlockState state, BlockPos pos, Random rand) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    BlockPos checkPos = new BlockPos(pos.func_177958_n() + (j - 1), pos.func_177956_o() - i - 1, pos.func_177952_p() + (k - 1));
                    if (!world.func_180495_p(checkPos.func_177972_a(Direction.UP)).func_185904_a().func_76222_j() || !world.func_180495_p(checkPos).func_224755_d((IBlockReader)world, checkPos, Direction.UP) || rand.nextInt(3) != 0) continue;
                    world.func_175656_a(checkPos.func_177972_a(Direction.UP), BlockRegistry.elder_leaf_layer.func_176223_P());
                    return;
                }
            }
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        if (this.isGrowable(worldIn, pos)) {
            if (CropLifeStageType.checkCropLife(worldIn) == CropLifeStageType.BERRY && state.func_177229_b(LIFE_STAGE) != CropLifeStageType.BERRY && this.func_185525_y(state)) {
                worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)MID_BERRY, (Comparable)Boolean.valueOf(true))).func_206870_a(LIFE_STAGE, (Comparable)((Object)CropLifeStageType.BERRY)));
            } else if (((Boolean)worldIn.func_180495_p(pos).func_177229_b((Property)MID_BERRY)).booleanValue() && this.func_185525_y(state)) {
                worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)MID_BERRY, (Comparable)Boolean.valueOf(false))).func_206870_a(LIFE_STAGE, (Comparable)((Object)CropLifeStageType.BERRY)));
            } else {
                int j;
                int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
                if (i > (j = this.func_185526_g())) {
                    i = j;
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)));
            }
        }
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    protected int func_185529_b(World worldIn) {
        return 1;
    }

    protected static float getGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        float f = 5.0f;
        if (worldIn.func_217298_h(pos) >= 9) {
            return f;
        }
        return f / 1.2f;
    }

    public static Boolean isOnLeaves(IWorldReader world, BlockPos pos) {
        Direction direction = ((Direction)world.func_180495_p(pos).func_177229_b((Property)FACING)).func_176734_d();
        return world.func_180495_p(pos.func_177972_a(direction.func_176734_d())).func_177230_c() instanceof ElderLeavesBlock;
    }

    @Override
    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return ElderFruitBlock.isOnLeaves(worldIn, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (this.func_185525_y(state) && (!((Boolean)state.func_177229_b((Property)MID_BERRY)).booleanValue() || state.func_177229_b(LIFE_STAGE) != CropLifeStageType.BERRY)) {
            worldIn.func_175655_b(pos, true);
        } else if (this.func_185525_y(state) && ((Boolean)state.func_177229_b((Property)MID_BERRY)).booleanValue()) {
            return ActionResultType.FAIL;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.func_185525_y(state) && this.isGrowable((World)worldIn, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return this.isGrowable(worldIn, pos);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, FACING, LIFE_STAGE, MID_BERRY});
    }
}

