/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.vulp.druidcraft.registry.ParticleRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulfireBlock
extends Block {
    private final DyeColor color;
    private static final Map<DyeColor, int[]> DYE_COLOR_MAP = new HashMap<DyeColor, int[]>();

    public SoulfireBlock(DyeColor color, AbstractBlock.Properties properties) {
        super(properties);
        this.color = color;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        return Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    }

    private int[] getSmokeColorArray() {
        return DYE_COLOR_MAP.getOrDefault(this.getSmokeColor(), new int[]{0, 0, 0});
    }

    private DyeColor getSmokeColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void particleTick(BlockState state, World world, BlockPos pos, Random random) {
        if (random.nextInt(8) == 0) {
            super.func_180655_c(state, world, pos, random);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.5;
            double d2 = (double)pos.func_177952_p() + 0.5;
            int[] color = this.getSmokeColorArray();
            float limit = 0.1f;
            for (int i = 0; i < 7; ++i) {
                float offset1 = Math.min(limit, Math.max(-limit, random.nextFloat() - 0.5f));
                float offset2 = Math.min(limit, Math.max(-limit, random.nextFloat() - 0.5f));
                float offset3 = Math.min(limit, Math.max(-limit, random.nextFloat() - 0.5f));
                world.func_195590_a((IParticleData)ParticleRegistry.magic_smoke, false, d0 + (double)offset1, d1 + (double)offset2, d2 + (double)offset3, (double)((float)color[0] / 255.0f), (double)((float)color[1] / 255.0f), (double)((float)color[2] / 255.0f));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (random.nextInt(4) != 0) {
            super.func_180655_c(state, world, pos, random);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.5;
            double d2 = (double)pos.func_177952_p() + 0.5;
            int[] color = this.getSmokeColorArray();
            float limit = 0.1f;
            float offset1 = Math.min(limit, Math.max(-limit, random.nextFloat() - 0.5f));
            float offset2 = Math.min(limit, Math.max(-limit, random.nextFloat() - 0.5f));
            float offset3 = Math.min(limit, Math.max(-limit, random.nextFloat() - 0.5f));
            world.func_195590_a((IParticleData)ParticleRegistry.magic_smoke, false, d0 + (double)offset1, d1 + (double)offset2, d2 + (double)offset3, (double)((float)color[0] / 255.0f), (double)((float)color[1] / 255.0f), (double)((float)color[2] / 255.0f));
        }
    }

    static {
        DYE_COLOR_MAP.put(DyeColor.BLACK, new int[]{15, 15, 15});
        DYE_COLOR_MAP.put(DyeColor.RED, new int[]{255, 20, 10});
        DYE_COLOR_MAP.put(DyeColor.GREEN, new int[]{18, 150, 13});
        DYE_COLOR_MAP.put(DyeColor.BROWN, new int[]{90, 45, 5});
        DYE_COLOR_MAP.put(DyeColor.BLUE, new int[]{15, 20, 255});
        DYE_COLOR_MAP.put(DyeColor.PURPLE, new int[]{140, 15, 220});
        DYE_COLOR_MAP.put(DyeColor.CYAN, new int[]{15, 150, 130});
        DYE_COLOR_MAP.put(DyeColor.LIGHT_GRAY, new int[]{125, 125, 125});
        DYE_COLOR_MAP.put(DyeColor.GRAY, new int[]{60, 60, 60});
        DYE_COLOR_MAP.put(DyeColor.PINK, new int[]{255, 115, 170});
        DYE_COLOR_MAP.put(DyeColor.LIME, new int[]{130, 255, 20});
        DYE_COLOR_MAP.put(DyeColor.YELLOW, new int[]{255, 230, 2});
        DYE_COLOR_MAP.put(DyeColor.LIGHT_BLUE, new int[]{50, 200, 255});
        DYE_COLOR_MAP.put(DyeColor.MAGENTA, new int[]{205, 60, 155});
        DYE_COLOR_MAP.put(DyeColor.ORANGE, new int[]{250, 135, 5});
        DYE_COLOR_MAP.put(DyeColor.WHITE, new int[]{215, 215, 215});
    }
}

