/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks.tileentities;

import com.vulp.druidcraft.blocks.Hellkiln;
import com.vulp.druidcraft.blocks.HellkilnIgniter;
import com.vulp.druidcraft.blocks.tileentities.HellkilnIgniterTileEntity;
import com.vulp.druidcraft.inventory.container.HellkilnContainer;
import com.vulp.druidcraft.recipes.HellkilnRecipe;
import com.vulp.druidcraft.recipes.IModdedRecipeType;
import com.vulp.druidcraft.registry.GUIRegistry;
import com.vulp.druidcraft.registry.TileEntityRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HellkilnTileEntity
extends LockableTileEntity
implements ITickableTileEntity,
IRecipeHolder,
IRecipeHelperPopulator {
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int burnTime;
    private int recipesUsed;
    private int cookTime;
    private int cookTimeTotal;
    private int igniterCount;
    private int speed;
    private int igniterFuelCountLeft;
    private int igniterFuelCountBack;
    private int igniterFuelCountRight;
    private ArrayList<BlockPos> igniterList;
    protected final IIntArray hellkilnData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return HellkilnTileEntity.this.burnTime;
                }
                case 1: {
                    return HellkilnTileEntity.this.recipesUsed;
                }
                case 2: {
                    return HellkilnTileEntity.this.cookTime;
                }
                case 3: {
                    return HellkilnTileEntity.this.cookTimeTotal;
                }
                case 4: {
                    return HellkilnTileEntity.this.igniterCount;
                }
                case 5: {
                    return HellkilnTileEntity.this.igniterFuelCountLeft;
                }
                case 6: {
                    return HellkilnTileEntity.this.igniterFuelCountBack;
                }
                case 7: {
                    return HellkilnTileEntity.this.igniterFuelCountRight;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    HellkilnTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    HellkilnTileEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    HellkilnTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    HellkilnTileEntity.this.cookTimeTotal = value;
                    break;
                }
                case 4: {
                    HellkilnTileEntity.this.igniterCount = value;
                    break;
                }
                case 5: {
                    HellkilnTileEntity.this.igniterFuelCountLeft = value;
                    break;
                }
                case 6: {
                    HellkilnTileEntity.this.igniterFuelCountBack = value;
                    break;
                }
                case 7: {
                    HellkilnTileEntity.this.igniterFuelCountRight = value;
                }
            }
        }

        public int func_221478_a() {
            return 8;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    protected final IRecipeType<? extends HellkilnRecipe> recipeType;

    public HellkilnTileEntity() {
        this(TileEntityRegistry.hellkiln, IModdedRecipeType.hellkiln_smelting);
    }

    public HellkilnTileEntity(TileEntityType<?> typeIn, IRecipeType<? extends HellkilnRecipe> recipeTypeIn) {
        super(typeIn);
        this.recipeType = recipeTypeIn;
    }

    public boolean hasFuel() {
        return this.igniterCount > 0;
    }

    public int checkFuel() {
        return this.getStatesFromPositions(this.igniterList).size();
    }

    public void useFuel(int amount) {
        ArrayList<HellkilnIgniterTileEntity> list = this.getTilesFromPositions(this.igniterList);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            list.get(i).deductFuel(amount);
        }
    }

    public static boolean isValidIgniter(BlockState state, TileEntity tile, Direction direction) {
        return state.func_177230_c() instanceof HellkilnIgniter && tile instanceof HellkilnIgniterTileEntity && state.func_177229_b((Property)HellkilnIgniter.FACING) == direction && (Boolean)state.func_177229_b((Property)HellkilnIgniter.LIT) != false;
    }

    public void refreshIgniterList() {
        World world = this.field_145850_b;
        BlockPos pos = this.func_174877_v();
        Direction direction = ((Direction)world.func_180495_p(pos).func_177229_b((Property)Hellkiln.FACING)).func_176746_e();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = 0; i < 3; ++i) {
            if (HellkilnTileEntity.isValidIgniter(world.func_180495_p(pos.func_177972_a(direction)), world.func_175625_s(pos.func_177972_a(direction)), direction)) {
                list.add(pos.func_177972_a(direction));
            } else {
                list.add(null);
            }
            direction = direction.func_176746_e();
        }
        this.igniterList = list;
    }

    public ArrayList<BlockState> getStatesFromPositions(ArrayList<BlockPos> posList) {
        World world = this.field_145850_b;
        ArrayList<BlockState> stateList = new ArrayList<BlockState>();
        for (int i = 0; i < posList.size(); ++i) {
            if (posList.get(i) == null) continue;
            stateList.add(world.func_180495_p(posList.get(i)));
        }
        return stateList;
    }

    public ArrayList<HellkilnIgniterTileEntity> getTilesFromPositions(ArrayList<BlockPos> posList) {
        World world = this.field_145850_b;
        ArrayList<HellkilnIgniterTileEntity> tileList = new ArrayList<HellkilnIgniterTileEntity>();
        for (int i = 0; i < posList.size(); ++i) {
            if (posList.get(i) != null) {
                tileList.add((HellkilnIgniterTileEntity)world.func_175625_s(posList.get(i)));
                continue;
            }
            tileList.add(null);
        }
        return tileList;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.igniterList != null) {
            ArrayList<HellkilnIgniterTileEntity> tileList = this.getTilesFromPositions(this.igniterList);
            this.igniterFuelCountLeft = tileList.get(0) != null ? tileList.get(0).getFuel() : -1;
            this.igniterFuelCountBack = tileList.get(1) != null ? tileList.get(1).getFuel() : -1;
            this.igniterFuelCountRight = tileList.get(2) != null ? tileList.get(2).getFuel() : -1;
        } else {
            this.refreshIgniterList();
        }
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack1 = (ItemStack)this.items.get(0);
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (this.isBurning() || !itemstack1.func_190926_b() && !itemstack2.func_190926_b() && this.hasFuel()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe)) {
                    this.burnTime = this.getBurnTime();
                    this.speed = this.checkFuel();
                    this.recipesUsed = this.burnTime;
                    if (this.isBurning()) {
                        flag1 = true;
                        if (this.hasFuel()) {
                            this.useFuel(1);
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe)) {
                    for (int i = 0; i < this.speed; ++i) {
                        ++this.cookTime;
                    }
                    if (this.cookTime >= this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTime();
                        this.smelt(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)Hellkiln.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipeIn) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && !((ItemStack)this.items.get(1)).func_190926_b() && recipeIn != null) {
            ItemStack itemstack = recipeIn.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void smelt(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = (ItemStack)this.items.get(1);
            ItemStack itemstack2 = recipe.func_77571_b();
            ItemStack itemstack3 = (ItemStack)this.items.get(2);
            if (itemstack3.func_190926_b()) {
                this.items.set(2, (Object)itemstack2.func_77946_l());
            } else if (itemstack3.func_77973_b() == itemstack2.func_77973_b()) {
                itemstack3.func_190917_f(itemstack2.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            itemstack.func_190918_g(1);
            itemstack1.func_190918_g(1);
        }
    }

    protected int getBurnTime() {
        if (!this.hasFuel()) {
            return 0;
        }
        return 5;
    }

    protected int getCookTime() {
        return 2400;
    }

    public boolean isBurning() {
        return this.burnTime > 0 && !((ItemStack)this.items.get(0)).func_190926_b() && !((ItemStack)this.items.get(1)).func_190926_b();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.druidcraft.hellkiln");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new HellkilnContainer(GUIRegistry.hellkiln, IModdedRecipeType.hellkiln_smelting, RecipeBookCategory.FURNACE, id, player, (IInventory)this, this.hellkilnData);
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.func_199560_c();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_201560_d(PlayerEntity player) {
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.items) {
            helper.func_194112_a(itemstack);
        }
    }
}

