/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks.tileentities;

import com.vulp.druidcraft.blocks.RopeBlock;
import com.vulp.druidcraft.blocks.SmallBeamBlock;
import com.vulp.druidcraft.registry.TileEntityRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class SmallBeamTileEntity
extends TileEntity {
    private Boolean NORTH = false;
    private Boolean EAST = false;
    private Boolean SOUTH = false;
    private Boolean WEST = false;
    private Boolean UP = false;
    private Boolean DOWN = false;
    private Direction.Axis ROT = Direction.Axis.X;

    public SmallBeamTileEntity() {
        this(TileEntityRegistry.small_beam);
    }

    public SmallBeamTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("North", this.NORTH.booleanValue());
        compound.func_74757_a("East", this.EAST.booleanValue());
        compound.func_74757_a("South", this.SOUTH.booleanValue());
        compound.func_74757_a("West", this.WEST.booleanValue());
        compound.func_74757_a("Up", this.UP.booleanValue());
        compound.func_74757_a("Down", this.DOWN.booleanValue());
        compound.func_74768_a("Rotation", this.axisToInt(this.ROT));
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.NORTH = compound.func_74767_n("North");
        this.EAST = compound.func_74767_n("East");
        this.SOUTH = compound.func_74767_n("South");
        this.WEST = compound.func_74767_n("West");
        this.UP = compound.func_74767_n("Up");
        this.DOWN = compound.func_74767_n("Down");
        this.ROT = this.intToAxis(compound.func_74762_e("Rotation"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public int axisToInt(Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return 1;
        }
        if (axis == Direction.Axis.Y) {
            return 2;
        }
        return 3;
    }

    @Nullable
    public Direction.Axis intToAxis(int i) {
        if (i == 1) {
            return Direction.Axis.X;
        }
        if (i == 2) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.Z;
    }

    public ArrayList<Boolean> getDirections() {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        list.add(this.NORTH);
        list.add(this.EAST);
        list.add(this.SOUTH);
        list.add(this.WEST);
        list.add(this.UP);
        list.add(this.DOWN);
        return list;
    }

    public Direction.Axis getRotation() {
        return this.ROT;
    }

    public void ropeConnectionCalculations(IWorld world, BlockState state, BlockPos pos) {
        boolean xAxis = (Boolean)state.func_177229_b((Property)SmallBeamBlock.X_AXIS);
        boolean yAxis = (Boolean)state.func_177229_b((Property)SmallBeamBlock.Y_AXIS);
        boolean zAxis = (Boolean)state.func_177229_b((Property)SmallBeamBlock.Z_AXIS);
        this.NORTH = world.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof RopeBlock && !zAxis;
        this.SOUTH = world.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof RopeBlock && !zAxis;
        this.EAST = world.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof RopeBlock && !xAxis;
        this.WEST = world.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof RopeBlock && !xAxis;
        this.UP = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof RopeBlock && !yAxis;
        this.DOWN = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof RopeBlock && !yAxis;
        this.ROT = xAxis ? Direction.Axis.X : (yAxis ? Direction.Axis.Y : Direction.Axis.Z);
    }
}

