/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.client.renders.layers;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.vulp.druidcraft.items.TravelPackItem;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class TravelPackLayer<T extends PlayerEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    protected final A normal_pack;
    protected final A bedroll_pack;
    private static final ResourceLocation REGULAR_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/regular.png");
    private static final ResourceLocation WHITE_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_white.png");
    private static final ResourceLocation ORANGE_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_orange.png");
    private static final ResourceLocation MAGENTA_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_magenta.png");
    private static final ResourceLocation LIGHT_BLUE_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_light_blue.png");
    private static final ResourceLocation YELLOW_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_yellow.png");
    private static final ResourceLocation LIME_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_lime.png");
    private static final ResourceLocation PINK_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_pink.png");
    private static final ResourceLocation GRAY_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_gray.png");
    private static final ResourceLocation LIGHT_GRAY_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_light_gray.png");
    private static final ResourceLocation CYAN_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_cyan.png");
    private static final ResourceLocation PURPLE_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_purple.png");
    private static final ResourceLocation BLUE_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_blue.png");
    private static final ResourceLocation BROWN_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_brown.png");
    private static final ResourceLocation GREEN_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_green.png");
    private static final ResourceLocation RED_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_red.png");
    private static final ResourceLocation BLACK_PACK_TEX = new ResourceLocation("druidcraft", "textures/entity/travel_pack/bedrolled_black.png");
    private static final Map<DyeColor, ResourceLocation> TEX_MAP = new ImmutableMap.Builder().put((Object)DyeColor.WHITE, (Object)WHITE_PACK_TEX).put((Object)DyeColor.ORANGE, (Object)ORANGE_PACK_TEX).put((Object)DyeColor.MAGENTA, (Object)MAGENTA_PACK_TEX).put((Object)DyeColor.LIGHT_BLUE, (Object)LIGHT_BLUE_PACK_TEX).put((Object)DyeColor.YELLOW, (Object)YELLOW_PACK_TEX).put((Object)DyeColor.LIME, (Object)LIME_PACK_TEX).put((Object)DyeColor.PINK, (Object)PINK_PACK_TEX).put((Object)DyeColor.GRAY, (Object)GRAY_PACK_TEX).put((Object)DyeColor.LIGHT_GRAY, (Object)LIGHT_GRAY_PACK_TEX).put((Object)DyeColor.CYAN, (Object)CYAN_PACK_TEX).put((Object)DyeColor.PURPLE, (Object)PURPLE_PACK_TEX).put((Object)DyeColor.BLUE, (Object)BLUE_PACK_TEX).put((Object)DyeColor.BROWN, (Object)BROWN_PACK_TEX).put((Object)DyeColor.GREEN, (Object)GREEN_PACK_TEX).put((Object)DyeColor.RED, (Object)RED_PACK_TEX).put((Object)DyeColor.BLACK, (Object)BLACK_PACK_TEX).build();

    public TravelPackLayer(IEntityRenderer<T, M> entityRenderer, A normalModel, A bedrolledModel) {
        super(entityRenderer);
        this.normal_pack = normalModel;
        this.bedroll_pack = bedrolledModel;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderPack(matrixStackIn, bufferIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, packedLightIn);
    }

    public void renderPack(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, T entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, int packedLightIn) {
        if (entityLivingBaseIn.getEntity() instanceof PlayerEntity) {
            IItemHandler handler = (IItemHandler)entityLivingBaseIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
            if (handler == null) {
                return;
            }
            int slotNum = -1;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack inSlot = handler.getStackInSlot(i);
                if (inSlot.func_77973_b() != ItemRegistry.travel_pack || ((PlayerEntity)entityLivingBaseIn).field_71071_by.field_70461_c == i) continue;
                slotNum = i;
                break;
            }
            if (slotNum != -1) {
                ItemStack travelPackItem = ((PlayerEntity)entityLivingBaseIn).field_71071_by.func_70301_a(slotNum);
                CompoundNBT nbt = travelPackItem.func_196082_o();
                DyeColor bedrollColor = nbt.func_74764_b("Color") || nbt.func_74762_e("Color") == -1 ? TravelPackItem.getColor(nbt) : null;
                A a = bedrollColor == null ? this.normal_pack : this.bedroll_pack;
                ((BipedModel)this.func_215332_c()).func_217148_a(a);
                a.func_212843_a_(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
                ResourceLocation resourceLocation = bedrollColor == null ? REGULAR_PACK_TEX : TEX_MAP.get(bedrollColor);
                IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)resourceLocation), (boolean)false, (boolean)false);
                a.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }
}

