/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities.AI.goals;

import com.vulp.druidcraft.api.IConditionalRangedAttackMob;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;

public class ConditionalRangedAttackGoal
extends Goal {
    private final MobEntity entityHost;
    private final IConditionalRangedAttackMob rangedAttackEntityHost;
    private LivingEntity attackTarget;
    private final double entityMoveSpeed;
    private int seeTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public ConditionalRangedAttackGoal(IConditionalRangedAttackMob mob, double moveSpeed, float attackRadius) {
        if (!(mob instanceof LivingEntity)) {
            throw new IllegalArgumentException("ConditionalRangedAttackGoal requires Mob implements IConditionalRangedAttackMob");
        }
        this.rangedAttackEntityHost = mob;
        this.entityHost = (MobEntity)mob;
        this.entityMoveSpeed = moveSpeed;
        this.attackRadius = attackRadius;
        this.maxAttackDistance = attackRadius * attackRadius;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity entity;
        if (this.rangedAttackEntityHost.shouldAttackWithRange() && (entity = this.entityHost.func_70638_az()) != null && entity.func_70089_S()) {
            this.attackTarget = entity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.rangedAttackEntityHost.shouldAttackWithRange()) {
            return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
        }
        return false;
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.seeTime = 0;
    }

    public void func_75246_d() {
        double lvt_1_1_ = this.entityHost.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_());
        boolean lvt_3_1_ = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.seeTime = lvt_3_1_ ? ++this.seeTime : 0;
        if (lvt_1_1_ <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (!lvt_3_1_) {
            return;
        }
        float lvt_4_1_ = MathHelper.func_76133_a((double)lvt_1_1_) / this.attackRadius;
        float lvt_5_1_ = MathHelper.func_76131_a((float)lvt_4_1_, (float)0.1f, (float)1.0f);
        this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
        this.rangedAttackEntityHost.resetCondition();
    }
}

