/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities;

import com.vulp.druidcraft.entities.AI.goals.FollowOwnerGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.NonTamedTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.OwnerHurtByTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.OwnerHurtTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.SitGoalMonster;
import com.vulp.druidcraft.entities.TameableMonsterEntity;
import com.vulp.druidcraft.events.EventFactory;
import com.vulp.druidcraft.pathfinding.ImprovedFlyingPathNavigator;
import com.vulp.druidcraft.registry.ParticleRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class DreadfishEntity
extends TameableMonsterEntity
implements IFlyingAnimal {
    private static final Predicate<LivingEntity> isPlayer;
    private static final DataParameter<Integer> SMOKE_COLOR;
    private static final Map<DyeColor, int[]> DYE_COLOR_MAP;
    private DyeColor smokeColor = null;
    private int cooldown;

    public DreadfishEntity(EntityType<? extends TameableMonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.setTamed(false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.sitGoal = new SitGoalMonster(this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.sitGoal);
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 3.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoalMonster(this, 2.0, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoalMonster(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoalMonster(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new NonTamedTargetGoalMonster<PlayerEntity>(this, PlayerEntity.class, false, isPlayer));
        this.field_70715_bh.func_75776_a(5, new NonTamedTargetGoalMonster<IronGolemEntity>(this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233822_e_, (double)0.4f).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233820_c_, 0.975).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SMOKE_COLOR, (Object)DyeColor.PURPLE.func_196059_a());
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public static boolean placement(EntityType<?> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && DreadfishEntity.isValidLightLevel(worldIn, pos, randomIn) && (worldIn.func_180495_p(pos.func_177977_b()).func_215688_a((IBlockReader)worldIn, pos.func_177977_b(), type) || worldIn.func_180495_p(pos.func_177977_b()).func_215688_a((IBlockReader)worldIn, pos.func_177979_c(2), type));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.2f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    private static boolean isValidLightLevel(IWorld world, BlockPos pos, Random rand) {
        if (world.func_226658_a_(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int i = world.func_72912_H().func_76061_m() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return i <= rand.nextInt(8);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.sitGoal != null) {
            this.sitGoal.setSitting(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Hostile", this.isHostile());
        compound.func_74774_a("SmokeColor", (byte)this.getSmokeColor().func_196059_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHostile(compound.func_74767_n("Hostile"));
        if (compound.func_150297_b("SmokeColor", 99)) {
            this.setSmokeColor(DyeColor.func_196056_a((int)compound.func_74762_e("SmokeColor")));
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        ImprovedFlyingPathNavigator flyingpathnavigator = new ImprovedFlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        flyingpathnavigator.func_188555_b(null);
        return flyingpathnavigator;
    }

    @Override
    public void setTamed(boolean tamed) {
        super.setTamed(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(24.0);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(16.0);
        }
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setHostile(false);
        } else if (!this.isTamed()) {
            this.setHostile(true);
        }
    }

    public int[] getSmokeColorArray() {
        return DYE_COLOR_MAP.getOrDefault(this.getSmokeColor(), new int[]{0, 0, 0});
    }

    public DyeColor getSmokeColor() {
        if (this.smokeColor == null) {
            this.smokeColor = DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(SMOKE_COLOR)));
        }
        return this.smokeColor;
    }

    public void setSmokeColor(DyeColor smokeColor) {
        this.field_70180_af.func_187227_b(SMOKE_COLOR, (Object)smokeColor.func_196059_a());
        this.smokeColor = smokeColor;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.isTamed()) {
            if (!itemstack.func_190926_b()) {
                DyeColor dyecolor;
                if (item == Items.field_151103_aS && this.func_110143_aJ() < this.func_110138_aP()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_70691_i(4.0f);
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
                if (item instanceof DyeItem && (dyecolor = ((DyeItem)item).func_195962_g()) != this.getSmokeColor()) {
                    this.setSmokeColor(dyecolor);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
            }
            if (this.isOwner((LivingEntity)player) && !this.field_70170_p.field_72995_K) {
                this.sitGoal.setSitting(!this.isSitting());
                this.func_70661_as().func_75499_g();
                this.func_70624_b(null);
            }
        } else if (item == Items.field_179563_cD) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !EventFactory.onMonsterTame(this, player)) {
                    this.playTameEffect(true);
                    this.setTamedBy(player);
                    this.func_70661_as().func_75499_g();
                    this.func_70624_b(null);
                    this.sitGoal.setSitting(true);
                    this.func_70606_j(24.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity)) {
            TameableEntity tameableEntity;
            TameableMonsterEntity monsterEntity;
            if (target instanceof TameableMonsterEntity && (monsterEntity = (TameableMonsterEntity)target).isTamed() && monsterEntity.getOwner() == this.getOwner()) {
                return false;
            }
            if (target instanceof TameableEntity && (tameableEntity = (TameableEntity)target).func_70909_n() && tameableEntity.func_70902_q() == this.getOwner()) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return !this.isHostile() && !this.isTamed();
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity) && !(entityIn instanceof DreadfishEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean isHostile() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 2) != 0;
    }

    public void setHostile(boolean hostile) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (hostile) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    @Override
    public boolean burnsInDaylight() {
        return !this.isTamed();
    }

    public void particle() {
        int[] color = this.getSmokeColorArray();
        this.field_70170_p.func_195590_a((IParticleData)ParticleRegistry.magic_smoke, false, this.func_226277_ct_(), this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5 + 0.25) / 4.0 + (double)0.1f, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5 + 0.2) / 3.0, (double)((float)color[0] / 255.0f), (double)((float)color[1] / 255.0f), (double)((float)color[2] / 255.0f));
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if ((int)(this.field_184619_aG * 10.0f) > 0 && this.field_70146_Z.nextInt((int)(this.field_184619_aG * 10.0f)) != 0) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.particle();
                }
            } else if (this.field_70146_Z.nextInt(8) == 0) {
                this.particle();
            }
        }
        if (this.cooldown < 120) {
            ++this.cooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isHostile()) {
            this.setHostile(false);
        }
        super.func_70636_d();
    }

    public boolean func_70617_f_() {
        return false;
    }

    static {
        SMOKE_COLOR = EntityDataManager.func_187226_a(DreadfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        DYE_COLOR_MAP = new HashMap<DyeColor, int[]>();
        isPlayer = type -> {
            EntityType entitytype = type.func_200600_R();
            return entitytype == EntityType.field_200729_aH;
        };
        DYE_COLOR_MAP.put(DyeColor.BLACK, new int[]{15, 15, 15});
        DYE_COLOR_MAP.put(DyeColor.RED, new int[]{255, 20, 10});
        DYE_COLOR_MAP.put(DyeColor.GREEN, new int[]{18, 150, 13});
        DYE_COLOR_MAP.put(DyeColor.BROWN, new int[]{90, 45, 5});
        DYE_COLOR_MAP.put(DyeColor.BLUE, new int[]{15, 20, 255});
        DYE_COLOR_MAP.put(DyeColor.PURPLE, new int[]{140, 15, 220});
        DYE_COLOR_MAP.put(DyeColor.CYAN, new int[]{15, 150, 130});
        DYE_COLOR_MAP.put(DyeColor.LIGHT_GRAY, new int[]{125, 125, 125});
        DYE_COLOR_MAP.put(DyeColor.GRAY, new int[]{60, 60, 60});
        DYE_COLOR_MAP.put(DyeColor.PINK, new int[]{255, 115, 170});
        DYE_COLOR_MAP.put(DyeColor.LIME, new int[]{130, 255, 20});
        DYE_COLOR_MAP.put(DyeColor.YELLOW, new int[]{255, 230, 2});
        DYE_COLOR_MAP.put(DyeColor.LIGHT_BLUE, new int[]{50, 200, 255});
        DYE_COLOR_MAP.put(DyeColor.MAGENTA, new int[]{205, 60, 155});
        DYE_COLOR_MAP.put(DyeColor.ORANGE, new int[]{250, 135, 5});
        DYE_COLOR_MAP.put(DyeColor.WHITE, new int[]{215, 215, 215});
    }
}

