/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities;

import com.vulp.druidcraft.entities.LunarMothColors;
import com.vulp.druidcraft.items.LunarMothJarItem;
import com.vulp.druidcraft.pathfinding.ImprovedFlyingPathNavigator;
import com.vulp.druidcraft.registry.ItemRegistry;
import com.vulp.druidcraft.registry.ParticleRegistry;
import com.vulp.druidcraft.registry.SoundEventRegistry;
import com.vulp.druidcraft.util.VectorUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LunarMothEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> RESTING = EntityDataManager.func_187226_a(LunarMothEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Direction> IDLING = EntityDataManager.func_187226_a(LunarMothEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    public static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(LunarMothEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final EntityPredicate entityPredicate = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    private BlockPos spawnPosition;

    public LunarMothEntity(EntityType<? extends LunarMothEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221657_bQ, Items.field_221764_cr, Items.field_222111_pQ, ItemRegistry.fiery_torch, ItemRegistry.ceramic_lantern, ItemRegistry.growth_lamp}), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentLunarMothGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233822_e_, (double)0.6f);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RESTING, (Object)false);
        this.field_70180_af.func_187214_a(IDLING, (Object)Direction.NORTH);
        this.field_70180_af.func_187214_a(COLOR, (Object)LunarMothColors.colorToInt(LunarMothColors.randomColor(this.field_70146_Z)));
    }

    public boolean isResting() {
        return (Boolean)this.field_70180_af.func_187225_a(RESTING);
    }

    public void setResting(boolean resting) {
        this.field_70180_af.func_187227_b(RESTING, (Object)resting);
    }

    public Direction getRestingDirection() {
        return (Direction)this.field_70180_af.func_187225_a(IDLING);
    }

    public void setRestingDirection(Direction direction) {
        this.field_70180_af.func_187227_b(IDLING, (Object)direction);
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151102_aT}).test(itemStack);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151069_bo) {
            player.func_130014_f_().func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEventRegistry.fill_bottle, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            this.bottleToMothJar(itemstack, player);
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    protected void bottleToMothJar(ItemStack itemstack, PlayerEntity player) {
        itemstack.func_190918_g(1);
        ItemStack stack = LunarMothJarItem.getItemStackByColor(this.getColor());
        CompoundNBT entityData = new CompoundNBT();
        this.func_213281_b(entityData);
        stack.func_196082_o().func_218657_a("EntityTag", (INBT)entityData);
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public LunarMothColors getColor() {
        return LunarMothColors.colorArray().get((Integer)this.field_70180_af.func_187225_a(COLOR));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.isResting()) {
            if (this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(entityPredicate, (LivingEntity)this) != null) {
                    this.setResting(false);
                    this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
                }
            } else {
                this.setResting(false);
                this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.spawnPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(6) - 2.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vector3d vec3d = this.func_213322_ci();
            Vector3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isResting()) {
            this.setResting(false);
        }
        return super.func_70097_a(source, amount);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        ImprovedFlyingPathNavigator flyingpathnavigator = new ImprovedFlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        flyingpathnavigator.func_188555_b(null);
        return flyingpathnavigator;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(RESTING, (Object)compound.func_74767_n("MothResting"));
        this.field_70180_af.func_187227_b(IDLING, (Object)Direction.func_82600_a((int)compound.func_74762_e("MothIdleDirection")));
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("Color"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("MothResting", ((Boolean)this.field_70180_af.func_187225_a(RESTING)).booleanValue());
        compound.func_74768_a("MothIdleDirection", ((Direction)this.field_70180_af.func_187225_a(IDLING)).func_176745_a());
        compound.func_74768_a("Color", ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue());
    }

    public static boolean placement(EntityType<LunarMothEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150350_a;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int red = 1;
            int green = 1;
            int blue = 1;
            if (this.getColor() == LunarMothColors.TURQUOISE) {
                red = 85;
                green = 255;
                blue = 160;
            }
            if (this.getColor() == LunarMothColors.PINK) {
                red = 255;
                green = 200;
                blue = 240;
            }
            if (this.getColor() == LunarMothColors.LIME) {
                red = 180;
                green = 255;
                blue = 110;
            }
            if (this.getColor() == LunarMothColors.ORANGE) {
                red = 255;
                green = 200;
                blue = 80;
            }
            if (this.getColor() == LunarMothColors.WHITE) {
                red = 255;
                green = 250;
                blue = 240;
            }
            if (this.getColor() == LunarMothColors.YELLOW) {
                red = 255;
                green = 255;
                blue = 140;
            }
            float colorMod = this.field_70146_Z.nextInt(3) == 3 ? 1.1f : (this.field_70146_Z.nextInt(3) == 3 ? 0.9f : 1.0f);
            if (this.field_70146_Z.nextBoolean()) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleRegistry.magic_glitter, false, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) / 3.0, this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5) / 3.0 + 0.2, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) / 3.0, (double)((float)red / 255.0f * colorMod), (double)((float)green / 255.0f * colorMod), (double)((float)blue / 255.0f * colorMod));
            }
        }
        if (this.func_70608_bn() || this.func_70610_aX()) {
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b / 2.0f;
    }

    class FollowParentLunarMothGoal
    extends FollowParentGoal {
        FollowParentLunarMothGoal(AnimalEntity child, double moveSpeed) {
            super(child, moveSpeed);
        }

        public boolean func_75250_a() {
            if (this.field_75348_a.func_70874_b() >= 0) {
                return false;
            }
            List lvt_1_1_ = this.field_75348_a.field_70170_p.func_217357_a(this.field_75348_a.getClass(), this.field_75348_a.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
            AnimalEntity lvt_2_1_ = null;
            double lvt_3_1_ = Double.MAX_VALUE;
            for (AnimalEntity lvt_6_1_ : lvt_1_1_) {
                double lvt_7_1_;
                if (lvt_6_1_.func_70874_b() < 0 || !((lvt_7_1_ = this.field_75348_a.func_70068_e((Entity)lvt_6_1_)) <= lvt_3_1_)) continue;
                lvt_3_1_ = lvt_7_1_;
                lvt_2_1_ = lvt_6_1_;
            }
            if (lvt_2_1_ == null) {
                return false;
            }
            if (lvt_3_1_ < 9.0) {
                return false;
            }
            this.field_75346_b = lvt_2_1_;
            LunarMothEntity entity = (LunarMothEntity)this.field_75346_b;
            return !entity.isResting();
        }

        public boolean func_75253_b() {
            if (this.field_75348_a.func_70874_b() >= 0) {
                return false;
            }
            LunarMothEntity entity = (LunarMothEntity)this.field_75346_b;
            if (!this.field_75346_b.func_70089_S() || entity.isResting()) {
                return false;
            }
            double lvt_1_1_ = this.field_75348_a.func_70068_e((Entity)this.field_75346_b);
            return lvt_1_1_ >= 9.0 && lvt_1_1_ <= 256.0;
        }
    }

    class RestOnWallGoal
    extends MoveToBlockGoal {
        private int sleepChance;

        RestOnWallGoal(LunarMothEntity creatureIn, double speed, int searchLength) {
            super((CreatureEntity)creatureIn, speed, searchLength);
            this.sleepChance = LunarMothEntity.this.field_70146_Z.nextInt(140);
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public boolean func_75250_a() {
            if (LunarMothEntity.this.isResting()) {
                return true;
            }
            return !LunarMothEntity.this.field_70170_p.func_226690_K_() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            if (!LunarMothEntity.this.field_70170_p.func_226690_K_()) {
                return super.func_75253_b();
            }
            return false;
        }

        public double func_203110_f() {
            return 1.14;
        }

        protected boolean func_179488_a(IWorldReader iWorldReader, BlockPos blockPos) {
            return false;
        }

        public void func_75246_d() {
            Vector3d vec3d = LunarMothEntity.this.func_213303_ch();
            Vector3d vec3d1 = new Vector3d((double)this.field_179494_b.func_177958_n(), (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p());
            Direction direction = VectorUtil.getDirection(vec3d, vec3d1);
            if (LunarMothEntity.this.field_70170_p.func_180495_p(this.field_179494_b).func_224755_d((IBlockReader)LunarMothEntity.this.field_70170_p, this.field_179494_b, direction)) {
                // empty if block
            }
            super.func_75246_d();
        }
    }
}

