/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities;

import com.vulp.druidcraft.entities.AI.goals.SitGoalMonster;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TameableMonsterEntity
extends CreatureEntity {
    static final DataParameter<Byte> TAMED = EntityDataManager.func_187226_a(TameableMonsterEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(TameableMonsterEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    SitGoalMonster sitGoal;

    TameableMonsterEntity(EntityType<? extends TameableMonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setupTamedAI();
        this.field_70728_aV = 5;
    }

    public PathNavigator func_70661_as() {
        if (this.func_184218_aH() && this.func_184187_bx() instanceof TameableMonsterEntity) {
            MobEntity mobentity = (MobEntity)this.func_184187_bx();
            return mobentity.func_70661_as();
        }
        return this.field_70699_by;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233823_f_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
        compound.func_74757_a("Sitting", this.isSitting());
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        if (compound.func_186855_b("Owner")) {
            uuid = compound.func_186857_a("Owner");
        } else {
            String s = compound.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        if (this.sitGoal != null) {
            this.sitGoal.setSitting(compound.func_74767_n("Sitting"));
        }
        this.setSitting(compound.func_74767_n("Sitting"));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isTamed() && !this.func_145818_k_();
    }

    public boolean func_213392_I() {
        return this.isTamed() || this.func_145818_k_();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD();
    }

    public boolean preventPlayerSleep(PlayerEntity player) {
        return !this.isTamed();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !this.isTamed()) {
            this.func_70106_y();
        }
    }

    public boolean burnsInDaylight() {
        return false;
    }

    public void func_70636_d() {
        if (this.func_204609_dp() && this.burnsInDaylight()) {
            this.func_70015_d(8);
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    void playTameEffect(boolean play) {
        BasicParticleType particle = ParticleTypes.field_197608_a;
        if (play) {
            particle = ParticleTypes.field_197633_z;
        }
        if (!play) {
            particle = ParticleTypes.field_197601_L;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isTamed() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (tamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.setupTamedAI();
    }

    private void setupTamedAI() {
    }

    public boolean isSitting() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 1) != 0;
    }

    public void setSitting(boolean sitting) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (sitting) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    void setTamedBy(PlayerEntity player) {
        this.setTamed(true);
        this.setOwnerId(player.func_110124_au());
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.isOwner(target) && super.func_213336_c(target);
    }

    boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    public boolean func_213373_a(double p_213373_1_, double p_213373_3_, double p_213373_5_, boolean p_213373_7_) {
        return super.func_213373_a(p_213373_1_, p_213373_3_, p_213373_5_, p_213373_7_);
    }

    public SitGoalMonster getAISit() {
        return this.sitGoal;
    }

    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        return true;
    }

    public Team func_96124_cp() {
        LivingEntity livingentity;
        if (this.isTamed() && (livingentity = this.getOwner()) != null) {
            return livingentity.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.isTamed()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.getOwner() instanceof ServerPlayerEntity) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b(), Util.field_240973_b_);
        }
        super.func_70645_a(cause);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !this.func_180431_b(source) && super.func_70097_a(source, amount);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public SoundCategory func_184176_by() {
        return this.isTamed() ? SoundCategory.NEUTRAL : SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184184_Z() {
        return this.isTamed() ? SoundEvents.field_187549_bG : SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return this.isTamed() ? SoundEvents.field_187547_bF : SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isTamed() ? SoundEvents.field_187543_bD : SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return this.isTamed() ? SoundEvents.field_187661_by : SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        if (this.isTamed()) {
            return heightIn > 4 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE;
        }
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }
}

