/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.events;

import com.vulp.druidcraft.config.EntitySpawnConfig;
import com.vulp.druidcraft.config.WorldGenConfig;
import com.vulp.druidcraft.registry.ConfiguredFeatureRegistry;
import com.vulp.druidcraft.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="druidcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeLoadEventHandler {
    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        Biome biome;
        BiomeGenerationSettingsBuilder settings;
        EntitySpawnConfig.verifyLists();
        if (event.getCategory() == Biome.Category.PLAINS || event.getCategory() == Biome.Category.RIVER) {
            settings = event.getGeneration();
            settings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatureRegistry.plains_river_elder_tree);
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            settings = event.getGeneration();
            settings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatureRegistry.forest_elder_tree);
        }
        if (event.getCategory() == Biome.Category.PLAINS || event.getCategory() == Biome.Category.FOREST || event.getCategory() == Biome.Category.RIVER || event.getCategory() == Biome.Category.EXTREME_HILLS || event.getCategory() == Biome.Category.TAIGA) {
            settings = event.getGeneration();
            settings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatureRegistry.blueberry_bush);
        }
        if (event.getCategory() == Biome.Category.PLAINS || event.getCategory() == Biome.Category.FOREST || event.getCategory() == Biome.Category.RIVER || event.getCategory() == Biome.Category.EXTREME_HILLS) {
            settings = event.getGeneration();
            settings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatureRegistry.lavender);
        }
        if (event.getCategory() != Biome.Category.NETHER && event.getCategory() != Biome.Category.THEEND) {
            settings = event.getGeneration();
            settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatureRegistry.amber);
            settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatureRegistry.moonstone);
            settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatureRegistry.fiery_glass);
            settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatureRegistry.rockroot);
        }
        if (event.getCategory() == Biome.Category.NETHER && ((Boolean)WorldGenConfig.generate_wip.get()).booleanValue()) {
            settings = event.getGeneration();
            settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredFeatureRegistry.nether_fiery_glass);
            settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredFeatureRegistry.brightstone);
        }
        if (event.getName() != null && (biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName())) != null) {
            ArrayList<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>(BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName())));
            if (BiomeLoadEventHandler.biomeCategoryChecker(EntitySpawnConfig.beetle_biome_whitelist, EntitySpawnConfig.beetle_biome_blacklist, biomeTypes, (Boolean)EntitySpawnConfig.beetle_spawn.get())) {
                event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityRegistry.beetle_entity, ((Integer)EntitySpawnConfig.beetle_weight.get()).intValue(), ((Integer)EntitySpawnConfig.beetle_min_group.get()).intValue(), ((Integer)EntitySpawnConfig.beetle_max_group.get()).intValue()));
            }
            if (BiomeLoadEventHandler.biomeCategoryChecker(EntitySpawnConfig.dreadfish_biome_whitelist, EntitySpawnConfig.dreadfish_biome_blacklist, biomeTypes, (Boolean)EntitySpawnConfig.dreadfish_spawn.get())) {
                event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityRegistry.dreadfish_entity, ((Integer)EntitySpawnConfig.dreadfish_weight.get()).intValue(), ((Integer)EntitySpawnConfig.dreadfish_min_group.get()).intValue(), ((Integer)EntitySpawnConfig.dreadfish_max_group.get()).intValue()));
            }
            if (BiomeLoadEventHandler.biomeCategoryChecker(EntitySpawnConfig.lunar_moth_biome_whitelist, EntitySpawnConfig.lunar_moth_biome_blacklist, biomeTypes, (Boolean)EntitySpawnConfig.lunar_moth_spawn.get())) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityRegistry.lunar_moth_entity, ((Integer)EntitySpawnConfig.lunar_moth_weight.get()).intValue(), ((Integer)EntitySpawnConfig.lunar_moth_min_group.get()).intValue(), ((Integer)EntitySpawnConfig.lunar_moth_max_group.get()).intValue()));
            }
        }
    }

    public static boolean biomeCategoryChecker(ArrayList<String> whitelist, ArrayList<String> blacklist, List<BiomeDictionary.Type> biomeTypes, boolean canSpawn) {
        if (canSpawn) {
            boolean checker = false;
            for (BiomeDictionary.Type biomeType : biomeTypes) {
                if (whitelist.contains(biomeType.getName())) {
                    checker = true;
                }
                if (!blacklist.contains(biomeType.getName())) continue;
                return false;
            }
            return checker;
        }
        return false;
    }
}

