/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.items;

import com.vulp.druidcraft.Druidcraft;
import com.vulp.druidcraft.api.BedrollDyeColorIndex;
import com.vulp.druidcraft.blocks.BedrollBlock;
import com.vulp.druidcraft.entities.TameableMonsterEntity;
import com.vulp.druidcraft.inventory.TravelPackInventory;
import com.vulp.druidcraft.inventory.container.TravelPackContainer;
import com.vulp.druidcraft.items.BedrollItem;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class TravelPackItem
extends Item {
    public TravelPackItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        final ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (!worldIn.field_72995_K && playerIn instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return itemstack.func_200301_q();
                }

                @Nullable
                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    return new TravelPackContainer(i, playerInventory, (IInventory)new TravelPackInventory(itemstack), itemstack);
                }
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public static void deployBedroll(int entityID, @Nullable World world) {
        Entity entity;
        if (world != null && (entity = world.func_73045_a(entityID)) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof TravelPackItem ? player.func_184586_b(Hand.MAIN_HAND) : player.func_184586_b(Hand.OFF_HAND);
            CompoundNBT nbt = itemStack.func_77978_p();
            TravelPackInventory inventory = new TravelPackInventory(itemStack);
            BlockPos pos = player.func_233580_cy_();
            Direction direction = player.func_174811_aO();
            if (!player.func_184812_l_()) {
                List list = world.func_175647_a(MonsterEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - 10.0, (double)pos.func_177956_o() - 6.0, (double)pos.func_177952_p() - 10.0, (double)pos.func_177958_n() + 10.0, (double)pos.func_177956_o() + 6.0, (double)pos.func_177952_p() + 10.0), monsterEntity -> monsterEntity.func_230292_f_(player));
                List list2 = world.func_175647_a(TameableMonsterEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - 10.0, (double)pos.func_177956_o() - 6.0, (double)pos.func_177952_p() - 10.0, (double)pos.func_177958_n() + 10.0, (double)pos.func_177956_o() + 6.0, (double)pos.func_177952_p() + 10.0), tameableMonsterEntity -> tameableMonsterEntity.preventPlayerSleep(player));
                if (!list.isEmpty() || !list2.isEmpty()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("block.druidcraft.bedroll.fail.monsters"), true);
                    return;
                }
            }
            if (!world.func_230315_m_().func_241510_j_()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.druidcraft.bedroll.fail.dimension"), true);
                return;
            }
            if (!world.field_72995_K && !ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, Optional.of(pos))) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.druidcraft.bedroll.fail.time"), true);
                return;
            }
            Druidcraft.LOGGER.debug("Deploying!");
            for (Direction dir : Direction.values()) {
                BlockPos bedrollPos;
                if (dir == Direction.UP || dir == Direction.DOWN || dir == direction || (bedrollPos = TravelPackItem.bedrollPlacementHelper(world, pos, direction, DyeColor.func_196056_a((int)nbt.func_74762_e("Color")))) == null) continue;
                nbt.func_74768_a("BedrollPosX", bedrollPos.func_177958_n());
                nbt.func_74768_a("BedrollPosY", bedrollPos.func_177956_o());
                nbt.func_74768_a("BedrollPosZ", bedrollPos.func_177952_p());
                inventory.func_70304_b(0);
                inventory.writeItemStack();
                nbt.func_74768_a("Color", -1);
                player.func_213819_a(bedrollPos).ifLeft(p_220173_1_ -> {
                    if (p_220173_1_ != null) {
                        player.func_146105_b(p_220173_1_.func_221259_a(), true);
                    }
                });
                return;
            }
            for (Direction dir : Direction.values()) {
                if (dir == Direction.UP || dir == Direction.DOWN || dir == direction) continue;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            BlockPos bedrollPos = TravelPackItem.bedrollPlacementHelper(world, pos, direction, DyeColor.func_196056_a((int)nbt.func_74762_e("Color")));
                            if (bedrollPos == null) continue;
                            nbt.func_74768_a("BedrollPosX", bedrollPos.func_177958_n());
                            nbt.func_74768_a("BedrollPosY", bedrollPos.func_177956_o());
                            nbt.func_74768_a("BedrollPosZ", bedrollPos.func_177952_p());
                            inventory.func_70304_b(0);
                            inventory.writeItemStack();
                            nbt.func_74768_a("Color", -1);
                            player.func_213819_a(bedrollPos).ifLeft(p_220173_1_ -> {
                                if (p_220173_1_ != null) {
                                    player.func_146105_b(p_220173_1_.func_221259_a(), true);
                                }
                            });
                            return;
                        }
                    }
                }
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.druidcraft.bedroll.fail.placement"), true);
        }
    }

    public static void bedrollSleepHelper(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        ((BedrollBlock)state.func_177230_c()).func_225533_a_(state, worldIn, pos, player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.NORTH, pos, true));
    }

    @Nullable
    public static BlockPos bedrollPlacementHelper(World world, BlockPos pos, Direction direction, DyeColor color) {
        BlockPos foot = pos;
        BlockPos head = pos.func_177972_a(direction);
        if (world.func_180495_p(head).func_185904_a().func_76222_j() && world.func_180495_p(foot).func_185904_a().func_76222_j()) {
            world.func_175656_a(foot, (BlockState)((BlockState)((BlockState)BedrollDyeColorIndex.byIndex(color.func_196059_a()).getBedrollBlock().func_176223_P().func_206870_a((Property)BedrollBlock.field_185512_D, (Comparable)direction)).func_206870_a((Property)BedrollBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((Property)BedrollBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_180495_p(foot).func_177230_c() == Blocks.field_150355_j)));
            world.func_175656_a(head, (BlockState)((BlockState)((BlockState)BedrollDyeColorIndex.byIndex(color.func_196059_a()).getBedrollBlock().func_176223_P().func_206870_a((Property)BedrollBlock.field_185512_D, (Comparable)direction)).func_206870_a((Property)BedrollBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((Property)BedrollBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_180495_p(head).func_177230_c() == Blocks.field_150355_j)));
            return head;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    foot = pos.func_177982_a(i, j, k);
                    head = pos.func_177982_a(i, j, k).func_177972_a(direction);
                    if (!world.func_180495_p(head).func_185904_a().func_76222_j() || !world.func_180495_p(foot).func_185904_a().func_76222_j()) continue;
                    world.func_175656_a(foot, (BlockState)((BlockState)((BlockState)BedrollDyeColorIndex.byIndex(color.func_196059_a()).getBedrollBlock().func_176223_P().func_206870_a((Property)BedrollBlock.field_185512_D, (Comparable)direction)).func_206870_a((Property)BedrollBlock.field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((Property)BedrollBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_180495_p(foot).func_177230_c() == Blocks.field_150355_j)));
                    world.func_175656_a(head, (BlockState)((BlockState)((BlockState)BedrollDyeColorIndex.byIndex(color.func_196059_a()).getBedrollBlock().func_176223_P().func_206870_a((Property)BedrollBlock.field_185512_D, (Comparable)direction)).func_206870_a((Property)BedrollBlock.field_176472_a, (Comparable)BedPart.HEAD)).func_206870_a((Property)BedrollBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_180495_p(head).func_177230_c() == Blocks.field_150355_j)));
                    return head;
                }
            }
        }
        return null;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean isHeldItem) {
        if (isHeldItem) {
            TravelPackInventory travelPackInventory = new TravelPackInventory(itemStack);
            ItemStack bedroll = travelPackInventory.func_70301_a(0);
            int colorID = bedroll.func_77973_b() instanceof BedrollItem ? ((BedrollItem)bedroll.func_77973_b()).getColor().func_196059_a() : -1;
            CompoundNBT nbt = itemStack.func_196082_o();
            nbt.func_74768_a("Color", colorID);
        }
    }

    @Nullable
    public static DyeColor getColor(CompoundNBT nbt) {
        int colorID = nbt.func_74762_e("Color");
        if (colorID != -1) {
            return DyeColor.func_196056_a((int)nbt.func_74762_e("Color"));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.druidcraft.hold_shift").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.druidcraft.travel_pack.description1").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        return !(player.field_71070_bA instanceof TravelPackContainer);
    }
}

