/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.registry;

import com.vulp.druidcraft.DruidcraftRegistry;
import com.vulp.druidcraft.world.biomes.DarkwoodForestBiome;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeRegistry {
    private static final Set<Biome> BIOMES = new HashSet<Biome>();
    public static Biome darkwood_forest = BiomeRegistry.register("darkwood_forest", DarkwoodForestBiome.makeDarkwoodForest());

    public static Biome register(String name, Biome biome) {
        biome.setRegistryName(DruidcraftRegistry.location(name));
        BIOMES.add(biome);
        return biome;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BIOMES.toArray(new Biome[0]));
        BiomeRegistry.registerBiomes();
    }

    public static void registerBiomes() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(BiomeKeys.darkwood_forest, 1));
        BiomeDictionary.addTypes(BiomeKeys.darkwood_forest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DENSE);
    }

    public static class BiomeKeys {
        public static final RegistryKey<Biome> darkwood_forest = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)DruidcraftRegistry.location("darkwood_forest"));
    }
}

