/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.registry;

import com.vulp.druidcraft.DruidcraftRegistry;
import com.vulp.druidcraft.entities.BeetleEntity;
import com.vulp.druidcraft.entities.DreadfishEntity;
import com.vulp.druidcraft.entities.LunarMothEntity;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityRegistry {
    public static final EntityType<DreadfishEntity> dreadfish_entity = EntityRegistry.createEntity(DreadfishEntity::new, EntityClassification.MONSTER, "dreadfish", 0.8f, 0.4f);
    public static final EntityType<BeetleEntity> beetle_entity = EntityRegistry.createEntity(BeetleEntity::new, EntityClassification.MONSTER, "beetle", 1.5f, 1.5f);
    public static final EntityType<LunarMothEntity> lunar_moth_entity = EntityRegistry.createEntity(LunarMothEntity::new, EntityClassification.CREATURE, "lunar_moth", 0.5f, 0.5f);

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height) {
        return EntityRegistry.createEntity(factory, entityClassification, name, width, height, -1, null);
    }

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height, int trackingRange, BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory) {
        ResourceLocation location = new ResourceLocation("druidcraft", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3);
        if (customClientFactory != null) {
            builder.setCustomClientFactory(customClientFactory);
        }
        if (trackingRange != -1) {
            builder.setTrackingRange(trackingRange);
        }
        EntityType entity = builder.func_206830_a(location.toString());
        entity.setRegistryName(location);
        return entity;
    }

    public static void registerEntityAttributes() {
        GlobalEntityTypeAttributes.put(dreadfish_entity, (AttributeModifierMap)DreadfishEntity.bakeAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(beetle_entity, (AttributeModifierMap)BeetleEntity.bakeAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(lunar_moth_entity, (AttributeModifierMap)LunarMothEntity.bakeAttributes().func_233813_a_());
    }

    public static void registerEntitySpawnEggs(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemRegistry.dreadfish_spawn_egg = EntityRegistry.registerEntitySpawnEgg(dreadfish_entity, 14869209, 10974719, "dreadfish_spawn_egg"), ItemRegistry.beetle_spawn_egg = EntityRegistry.registerEntitySpawnEgg(beetle_entity, 5760476, 2258313, "beetle_spawn_egg"), ItemRegistry.lunar_moth_spawn_egg = EntityRegistry.registerEntitySpawnEgg(lunar_moth_entity, 4915138, 52873, "lunar_moth_spawn_egg")});
    }

    public static void registerEntityPlacements() {
        EntitySpawnPlacementRegistry.func_209343_a(beetle_entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BeetleEntity::placement);
        EntitySpawnPlacementRegistry.func_209343_a(dreadfish_entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DreadfishEntity::placement);
    }

    public static Item registerEntitySpawnEgg(EntityType<?> type, int color1, int color2, String name) {
        SpawnEggItem item = new SpawnEggItem(type, color1, color2, new Item.Properties().func_200916_a(DruidcraftRegistry.DRUIDCRAFT));
        item.setRegistryName(DruidcraftRegistry.location(name));
        return item;
    }
}

