/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.registry;

import com.vulp.druidcraft.world.config.BlockStateRadiusFeatureConfig;
import com.vulp.druidcraft.world.config.ElderTreeFeatureConfig;
import com.vulp.druidcraft.world.features.ElderTreeFeature;
import com.vulp.druidcraft.world.features.RadiusBlockBlobFeature;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FeatureRegistry {
    private static Set<Feature<?>> FEATURES = new HashSet();
    public static Feature<ElderTreeFeatureConfig> elder_tree = FeatureRegistry.register("elder_tree", new ElderTreeFeature(ElderTreeFeatureConfig.CODEC));
    public static Feature<BlockStateRadiusFeatureConfig> taiga_rock = FeatureRegistry.register("taiga_rock", new RadiusBlockBlobFeature(BlockStateRadiusFeatureConfig.CODEC));

    public static <V extends IFeatureConfig> Feature<V> register(String name, Feature<V> feature) {
        ResourceLocation id = new ResourceLocation("druidcraft", name);
        feature.setRegistryName(id);
        FEATURES.add(feature);
        return feature;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])FEATURES.toArray(new Feature[0]));
    }
}

