/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.world.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public class ElderTreeFeatureConfig
implements IFeatureConfig {
    public static final Codec<ElderTreeFeatureConfig> CODEC = RecordCodecBuilder.create(p_236683_0_ -> p_236683_0_.group((App)BlockStateProvider.field_236796_a_.fieldOf("trunk_provider").forGetter(p_236693_0_ -> p_236693_0_.trunkProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("root_provider").forGetter(p_236692_0_ -> p_236692_0_.rootProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("leaves_provider").forGetter(p_236692_0_ -> p_236692_0_.leavesProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("sapling_provider").forGetter(p_236692_0_ -> p_236692_0_.saplingProvider), (App)TreeDecorator.field_236874_c_.listOf().fieldOf("decorators").forGetter(p_236688_0_ -> p_236688_0_.decorators), (App)Heightmap.Type.field_236078_g_.fieldOf("heightmap").forGetter(p_236684_0_ -> p_236684_0_.heightmap)).apply((Applicative)p_236683_0_, ElderTreeFeatureConfig::new));
    public final BlockStateProvider trunkProvider;
    public final BlockStateProvider rootProvider;
    public final BlockStateProvider leavesProvider;
    public final BlockStateProvider saplingProvider;
    public final List<TreeDecorator> decorators;
    public transient boolean forcePlacement;
    public final Heightmap.Type heightmap;

    protected ElderTreeFeatureConfig(BlockStateProvider trunkProvider, BlockStateProvider rootProvider, BlockStateProvider leavesProvider, BlockStateProvider saplingProvider, List<TreeDecorator> decorators, Heightmap.Type p_i232020_9_) {
        this.trunkProvider = trunkProvider;
        this.rootProvider = rootProvider;
        this.leavesProvider = leavesProvider;
        this.saplingProvider = saplingProvider;
        this.decorators = decorators;
        this.heightmap = p_i232020_9_;
    }

    public void forcePlacement() {
        this.forcePlacement = true;
    }

    public ElderTreeFeatureConfig configureDecorators(List<TreeDecorator> p_236685_1_) {
        return new ElderTreeFeatureConfig(this.trunkProvider, this.rootProvider, this.leavesProvider, this.saplingProvider, p_236685_1_, this.heightmap);
    }

    public static class Builder {
        public final BlockStateProvider trunkProvider;
        public final BlockStateProvider rootProvider;
        public final BlockStateProvider leavesProvider;
        public final BlockStateProvider saplingProvider;
        private List<TreeDecorator> decorators = ImmutableList.of();
        private Heightmap.Type heightmap = Heightmap.Type.OCEAN_FLOOR;

        public Builder(BlockStateProvider trunkProvider, BlockStateProvider rootProvider, BlockStateProvider leavesProvider, BlockStateProvider saplingProvider) {
            this.trunkProvider = trunkProvider;
            this.rootProvider = rootProvider;
            this.leavesProvider = leavesProvider;
            this.saplingProvider = saplingProvider;
        }

        public Builder func_236703_a_(List<TreeDecorator> p_236703_1_) {
            this.decorators = p_236703_1_;
            return this;
        }

        public Builder setHeightmap(Heightmap.Type heightmap) {
            this.heightmap = heightmap;
            return this;
        }

        public ElderTreeFeatureConfig build() {
            return new ElderTreeFeatureConfig(this.trunkProvider, this.rootProvider, this.leavesProvider, this.saplingProvider, this.decorators, this.heightmap);
        }
    }
}

