/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.world.features;

import com.mojang.serialization.Codec;
import com.vulp.druidcraft.blocks.WoodBlock;
import com.vulp.druidcraft.registry.BlockRegistry;
import com.vulp.druidcraft.world.config.ElderTreeFeatureConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

public class ElderTreeFeature
extends Feature<ElderTreeFeatureConfig> {
    public static Random random = new Random();

    public ElderTreeFeature(Codec<ElderTreeFeatureConfig> codec) {
        super(codec);
    }

    public static boolean isDirtOrGrass(IWorldGenerationReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return ElderTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_150458_ak;
        });
    }

    public static int getMaxHeight(IWorldGenerationReader reader) {
        return reader instanceof IServerWorld ? ((IServerWorld)reader).func_201672_e().func_217301_I() : 256;
    }

    public static boolean func_236410_c_(IWorldGenerationBaseReader p_236410_0_, BlockPos p_236410_1_) {
        return ElderTreeFeature.isReplaceableAt(p_236410_0_, p_236410_1_) || p_236410_0_.func_217375_a(p_236410_1_, p_236417_0_ -> p_236417_0_.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader p_236404_0_, BlockPos p_236404_1_) {
        return ElderTreeFeature.isAirOrLeavesAt(p_236404_0_, p_236404_1_) || ElderTreeFeature.isTallPlantAt(p_236404_0_, p_236404_1_) || ElderTreeFeature.isWaterAt(p_236404_0_, p_236404_1_);
    }

    private static boolean isWaterAt(IWorldGenerationBaseReader p_236416_0_, BlockPos p_236416_1_) {
        return p_236416_0_.func_217375_a(p_236416_1_, p_236413_0_ -> p_236413_0_.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader p_236412_0_, BlockPos p_236412_1_) {
        return p_236412_0_.func_217375_a(p_236412_1_, p_236411_0_ -> p_236411_0_.func_196958_f() || p_236411_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isDirtOrFarmlandAt(IWorldGenerationBaseReader p_236418_0_, BlockPos p_236418_1_) {
        return p_236418_0_.func_217375_a(p_236418_1_, p_236409_0_ -> {
            Block lvt_1_1_ = p_236409_0_.func_177230_c();
            return ElderTreeFeature.func_227250_b_((Block)lvt_1_1_) || lvt_1_1_ == Blocks.field_150458_ak;
        });
    }

    private static boolean isTallPlantAt(IWorldGenerationBaseReader p_236419_0_, BlockPos p_236419_1_) {
        return p_236419_0_.func_217375_a(p_236419_1_, p_236406_0_ -> {
            Material lvt_1_1_ = p_236406_0_.func_185904_a();
            return lvt_1_1_ == Material.field_151582_l;
        });
    }

    public boolean generate(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos position, ElderTreeFeatureConfig config) {
        int height = rand.nextInt(2) + 6;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= ElderTreeFeature.getMaxHeight((IWorldGenerationReader)seedReader)) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (ElderTreeFeature.func_236410_c_((IWorldGenerationBaseReader)seedReader, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (ElderTreeFeature.isDirtOrGrass((IWorldGenerationReader)seedReader, position.func_177977_b()) && position.func_177956_o() < ElderTreeFeature.getMaxHeight((IWorldGenerationReader)seedReader) - height - 1) {
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                int logSide1 = rand.nextInt(3);
                for (int base = 0; base < height; ++base) {
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!ElderTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)seedReader, blockpos) && !seedReader.func_217375_a(blockpos, state -> state.func_177230_c() instanceof SaplingBlock)) continue;
                    if (base == 0) {
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177978_c().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177978_c().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177978_c())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177978_c(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177974_f().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177974_f().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177974_f())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177974_f(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177968_d().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177968_d().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177968_d())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177968_d(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177976_e().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177976_e().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177976_e())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177976_e(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177978_c().func_177974_f().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177978_c().func_177974_f().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177978_c().func_177974_f())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177978_c().func_177974_f(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177978_c().func_177976_e().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177978_c().func_177976_e().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177978_c().func_177976_e())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177978_c().func_177976_e(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177968_d().func_177974_f().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177968_d().func_177974_f().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177968_d().func_177974_f())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177968_d().func_177974_f(), true, config);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177968_d().func_177976_e().func_177977_b())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177968_d().func_177976_e().func_177977_b(), true, config);
                            } else if (ElderTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)seedReader, blockpos.func_177968_d().func_177976_e())) {
                                this.placeLogAt((IWorldGenerationReader)seedReader, blockpos.func_177968_d().func_177976_e(), true, config);
                            }
                        }
                        this.placeLogAt((IWorldGenerationReader)seedReader, blockpos, false, config);
                    }
                    if (base <= height - 1) {
                        this.placeLogAt((IWorldGenerationReader)seedReader, blockpos, false, config);
                        if (base == height - 2 || base == height - 3) {
                            if (logSide1 == 0) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177964_d(1), Direction.Axis.Z, config);
                            }
                            if (logSide1 == 1) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177965_g(1), Direction.Axis.X, config);
                            }
                            if (logSide1 == 2) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177970_e(1), Direction.Axis.Z, config);
                            }
                            if (logSide1 == 3) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177985_f(1), Direction.Axis.X, config);
                            }
                        }
                        if (base == height - 2 || base == height - 3) {
                            if (logSide1 == 0) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177964_d(1), Direction.Axis.Z, config);
                            }
                            if (logSide1 == 1) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177965_g(1), Direction.Axis.X, config);
                            }
                            if (logSide1 == 2) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177970_e(1), Direction.Axis.Z, config);
                            }
                            if (logSide1 == 3) {
                                this.placeRotatedLog((IWorldGenerationReader)seedReader, blockpos.func_177985_f(1), Direction.Axis.X, config);
                            }
                        }
                    }
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ).func_177977_b();
                for (int leafLayer1and3X = -3; leafLayer1and3X <= 3; ++leafLayer1and3X) {
                    for (int leafLayer1and3Z = -3; leafLayer1and3Z <= 3; ++leafLayer1and3Z) {
                        if ((leafLayer1and3X == 3 || leafLayer1and3X == -3) && (leafLayer1and3Z == 3 || leafLayer1and3Z == -3)) continue;
                        if (leafLayer1and3X == -3 && (leafLayer1and3Z == -2 || leafLayer1and3Z == 2) || leafLayer1and3X == 3 && (leafLayer1and3Z == -2 || leafLayer1and3Z == 2) || leafLayer1and3Z == -3 && (leafLayer1and3X == -2 || leafLayer1and3X == 2) || leafLayer1and3Z == 3 && (leafLayer1and3X == -2 || leafLayer1and3X == 2)) {
                            if (rand.nextBoolean() || rand.nextBoolean()) {
                                this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer1and3X, 0, leafLayer1and3Z), config);
                            }
                            if (!rand.nextBoolean() && !rand.nextBoolean()) continue;
                            this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer1and3X, -2, leafLayer1and3Z), config);
                            continue;
                        }
                        this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer1and3X, 0, leafLayer1and3Z), config);
                        this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer1and3X, -2, leafLayer1and3Z), config);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafLayer4X = -2; leafLayer4X <= 2; ++leafLayer4X) {
                    for (int leafLayer4Z = -2; leafLayer4Z <= 2; ++leafLayer4Z) {
                        if (leafLayer4X != -2 && leafLayer4X != 2 || leafLayer4Z != -2 && leafLayer4Z != 2) {
                            this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer4X, 0, leafLayer4Z), config);
                            continue;
                        }
                        if (!rand.nextBoolean()) continue;
                        this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer4X, 0, leafLayer4Z), config);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafLayer5X = -1; leafLayer5X <= 1; ++leafLayer5X) {
                    for (int leafLayer5Z = -1; leafLayer5Z <= 1; ++leafLayer5Z) {
                        if ((leafLayer5X == -1 || leafLayer5X == 1) && (leafLayer5Z == -1 || leafLayer5Z == 1)) continue;
                        this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer5X, 0, leafLayer5Z), config);
                    }
                }
                blockpos2 = blockpos2.func_177979_c(3);
                for (int leafLayer2X = -3; leafLayer2X <= 3; ++leafLayer2X) {
                    for (int leafLayer2Z = -3; leafLayer2Z <= 3; ++leafLayer2Z) {
                        if ((leafLayer2X == -3 || leafLayer2X == 3) && (leafLayer2Z == -3 || leafLayer2Z == 3)) continue;
                        this.placeLeafAt((IWorldGenerationReader)seedReader, blockpos2.func_177982_a(leafLayer2X, 0, leafLayer2Z), config);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeRotatedLog(IWorldGenerationReader reader, BlockPos pos, Direction.Axis setAxis, ElderTreeFeatureConfig config) {
        this.setElderLog(reader, pos, false, setAxis, config);
    }

    private void placeLogAt(IWorldGenerationReader reader, BlockPos pos, boolean isBaseWood, ElderTreeFeatureConfig config) {
        this.setElderLog(reader, pos, isBaseWood, null, config);
    }

    private void placeLeafAt(IWorldGenerationReader reader, BlockPos pos, ElderTreeFeatureConfig config) {
        this.setElderLeaf(reader, random, pos, config);
    }

    private void setElderLeaf(IWorldGenerationReader world, Random random, BlockPos pos, ElderTreeFeatureConfig config) {
        if (ElderTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)world, pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, config.leavesProvider.func_225574_a_(random, pos));
        }
    }

    private void setElderLog(IWorldGenerationReader world, BlockPos pos, boolean isBaseWood, @Nullable Direction.Axis setAxis, ElderTreeFeatureConfig config) {
        if (ElderTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)world, pos) || !world.func_217375_a(pos, state -> state.func_185904_a() == Material.field_151582_l) || !world.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150355_j))) {
            BlockState blockType = config.trunkProvider.func_225574_a_(random, pos);
            BlockState baseType = (BlockState)BlockRegistry.elder_wood.func_176223_P().func_206870_a((Property)WoodBlock.dropSelf, (Comparable)Boolean.valueOf(false));
            if (setAxis == null) {
                Random rand = new Random();
                if (isBaseWood) {
                    blockType = rand.nextInt(3) == 0 ? (BlockState)baseType.func_206870_a((Property)WoodBlock.field_176298_M, (Comparable)Direction.Axis.X) : (rand.nextInt(3) == 0 ? (BlockState)baseType.func_206870_a((Property)WoodBlock.field_176298_M, (Comparable)Direction.Axis.Y) : (BlockState)baseType.func_206870_a((Property)WoodBlock.field_176298_M, (Comparable)Direction.Axis.Z));
                }
            } else {
                blockType = (BlockState)blockType.func_206870_a((Property)WoodBlock.field_176298_M, (Comparable)setAxis);
            }
            this.func_230367_a_((IWorldWriter)world, pos, blockType);
        }
    }
}

