/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.features;

import com.google.common.collect.ImmutableMap;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.structures.GelStructurePiece;
import com.legacy.structure_gel.structures.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.structures.jigsaw.JigsawRegistryHelper;
import com.legacy.structure_gel.structures.processors.RandomBlockSwapProcessor;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;

public class EndRuinsPieces {
    public static void assemble(ChunkGenerator<?> chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed) {
        JigsawManager.func_214889_a((ResourceLocation)DungeonsPlus.locate("end_ruins/tower/base"), (int)7, Piece::new, chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed);
    }

    public static void init() {
    }

    static {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "end_ruins/");
        registry.register("pylon_plate_spacer", registry.builder().names(new String[]{"pylon_plate_spacer"}).build());
        registry.register("pylon_plate", registry.builder().names(new String[]{"pylon_plate"}).build(), JigsawPattern.PlacementBehaviour.TERRAIN_MATCHING);
        registry.register("pylon", JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.builder().names(new String[]{"pylon/tall", "pylon/medium", "pylon/small"}), registry.builder().weight(2).names(new String[]{"pylon/tall_broken", "pylon/medium_broken", "pylon/small_broken"})}));
        registry.register("pylon/debris", registry.builder().names(new String[]{"pylon/debris_1", "pylon/debris_2", "pylon/debris_3", "pylon/debris_4"}).build());
        JigsawRegistryHelper towerRegistry = registry.setPrefix("end_ruins/tower/");
        JigsawPoolBuilder towerPieces = towerRegistry.builder().processors(new StructureProcessor[]{new RandomBlockSwapProcessor(Blocks.field_196806_hJ, 0.1f, Blocks.field_150377_bs.func_176223_P())});
        towerRegistry.register("base", towerPieces.clone().names(new String[]{"base_1", "base_2"}).build());
        towerRegistry.register("mid", towerPieces.clone().names(new String[]{"mid_1", "mid_2"}).build());
        towerRegistry.register("top", towerPieces.clone().names(new String[]{"top_1", "top_2"}).build());
        towerRegistry.register("spine", towerRegistry.builder().names(new String[]{"spine"}).build());
        towerRegistry.register("block_pile", towerRegistry.builder().names((Map)ImmutableMap.of((Object)"block_pile_1", (Object)2, (Object)"block_pile_2", (Object)2, (Object)"block_pile_3", (Object)2, (Object)"block_pile_4", (Object)1)).build());
    }

    public static class Piece
    extends GelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super((IStructurePieceType)DungeonsPlus.Features.END_RUINS.getSecond(), template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, (IStructurePieceType)DungeonsPlus.Features.END_RUINS.getSecond());
        }

        public boolean func_74875_a(IWorld world, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos) {
            if (super.func_74875_a(world, rand, bounds, chunkPos)) {
                if (this.getLocation().toString().contains("end_ruins/tower/base_")) {
                    this.extendDown(world, Blocks.field_150377_bs.func_176223_P(), bounds, this.field_214834_c, rand);
                }
                if (this.getLocation().toString().contains("end_ruins/pylon/")) {
                    this.extendDown(world, Blocks.field_150343_Z.func_176223_P(), bounds, this.field_214834_c, rand);
                }
                return true;
            }
            return false;
        }

        public void handleDataMarker(String key, IWorld worldIn, BlockPos pos, Random rand, MutableBoundingBox bounds) {
            if (key.contains("spawner")) {
                this.setAir(worldIn, pos);
                String[] data = key.split("-");
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(data[1]));
                if (entityType == EntityType.field_203097_aH || entityType == EntityType.field_200803_q) {
                    worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
                    if (worldIn.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                        MobSpawnerTileEntity tile = (MobSpawnerTileEntity)worldIn.func_175625_s(pos);
                        tile.func_145881_a().func_200876_a(entityType);
                    }
                } else {
                    worldIn.func_180501_a(pos, Blocks.field_150343_Z.func_176223_P(), 3);
                }
            }
        }
    }
}

