/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.dungeons_plus.DungeonsConfig;
import com.legacy.dungeons_plus.features.BiggerDungeonPieces;
import com.legacy.dungeons_plus.features.BiggerDungeonStructure;
import com.legacy.dungeons_plus.features.EndRuinsPieces;
import com.legacy.dungeons_plus.features.EndRuinsStructure;
import com.legacy.dungeons_plus.features.LeviathanPieces;
import com.legacy.dungeons_plus.features.LeviathanStructure;
import com.legacy.dungeons_plus.features.SnowyTemplePieces;
import com.legacy.dungeons_plus.features.SnowyTempleStructure;
import com.legacy.dungeons_plus.features.TowerPieces;
import com.legacy.dungeons_plus.features.TowerStructure;
import com.legacy.structure_gel.access_helpers.JigsawAccessHelper;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.util.RegistryHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dungeons_plus")
public class DungeonsPlus {
    public static final String NAME = "Dungeons Plus";
    public static final String MODID = "dungeons_plus";
    public static final String VERSION = "1.0.1";
    public static final Logger LOGGER = LogManager.getLogger();

    public DungeonsPlus() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DungeonsConfig.COMMON_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
    }

    public void commonInit(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            Set types = BiomeDictionary.getTypes((Biome)biome);
            RegistryHelper.addFeature((Biome)biome, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES, (Feature)((Feature)Features.TOWER.getFirst()));
            RegistryHelper.addFeature((Biome)biome, (GenerationStage.Decoration)GenerationStage.Decoration.UNDERGROUND_STRUCTURES, (Feature)((Feature)Features.BIGGER_DUNGEON.getFirst()));
            RegistryHelper.addFeature((Biome)biome, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES, (Feature)((Feature)Features.LEVIATHAN.getFirst()));
            RegistryHelper.addFeature((Biome)biome, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES, (Feature)((Feature)Features.SNOWY_TEMPLE.getFirst()));
            RegistryHelper.addFeature((Biome)biome, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES, (Feature)((Feature)Features.END_RUINS.getFirst()));
            if (DungeonsConfig.COMMON.tower.isBiomeAllowed(biome)) {
                RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)Features.TOWER.getFirst()));
            }
            if (types.contains(BiomeDictionary.Type.OVERWORLD) && DungeonsConfig.COMMON.biggerDungeon.isBiomeAllowed(biome)) {
                RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)Features.BIGGER_DUNGEON.getFirst()));
            }
            if (DungeonsConfig.COMMON.leviathan.isBiomeAllowed(biome)) {
                RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)Features.LEVIATHAN.getFirst()));
            }
            if (DungeonsConfig.COMMON.snowyTemple.isBiomeAllowed(biome)) {
                RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)Features.SNOWY_TEMPLE.getFirst()));
            }
            if (!DungeonsConfig.COMMON.endRuins.isBiomeAllowed(biome)) continue;
            RegistryHelper.addStructure((Biome)biome, (Structure)((Structure)Features.END_RUINS.getFirst()));
        }
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Features {
        public static Pair<Structure<NoFeatureConfig>, IStructurePieceType> TOWER;
        public static Pair<Structure<NoFeatureConfig>, IStructurePieceType> LEVIATHAN;
        public static Pair<Structure<NoFeatureConfig>, IStructurePieceType> SNOWY_TEMPLE;
        public static Pair<Structure<NoFeatureConfig>, IStructurePieceType> BIGGER_DUNGEON;
        public static Pair<Structure<NoFeatureConfig>, IStructurePieceType> END_RUINS;

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Feature<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            TOWER = RegistryHelper.registerStructureAndPiece((IForgeRegistry)registry, (ResourceLocation)DungeonsPlus.locate("tower"), (Structure)new TowerStructure(NoFeatureConfig::func_214639_a, (ConfigTemplates.StructureConfig)DungeonsConfig.COMMON.tower), TowerPieces.Piece::new);
            LEVIATHAN = RegistryHelper.registerStructureAndPiece((IForgeRegistry)registry, (ResourceLocation)DungeonsPlus.locate("leviathan"), (Structure)new LeviathanStructure(NoFeatureConfig::func_214639_a, (ConfigTemplates.StructureConfig)DungeonsConfig.COMMON.leviathan), LeviathanPieces.Piece::new);
            SNOWY_TEMPLE = RegistryHelper.registerStructureAndPiece((IForgeRegistry)registry, (ResourceLocation)DungeonsPlus.locate("snowy_temple"), (Structure)new SnowyTempleStructure(NoFeatureConfig::func_214639_a, (ConfigTemplates.StructureConfig)DungeonsConfig.COMMON.snowyTemple), SnowyTemplePieces.Piece::new);
            BIGGER_DUNGEON = RegistryHelper.registerStructureAndPiece((IForgeRegistry)registry, (ResourceLocation)DungeonsPlus.locate("bigger_dungeon"), (Structure)new BiggerDungeonStructure(NoFeatureConfig::func_214639_a, (ConfigTemplates.StructureConfig)DungeonsConfig.COMMON.biggerDungeon), BiggerDungeonPieces.Piece::new);
            END_RUINS = RegistryHelper.registerStructureAndPiece((IForgeRegistry)registry, (ResourceLocation)DungeonsPlus.locate("end_ruins"), (Structure)new EndRuinsStructure(NoFeatureConfig::func_214639_a, (ConfigTemplates.StructureConfig)DungeonsConfig.COMMON.endRuins), EndRuinsPieces.Piece::new);
            JigsawAccessHelper.addIllagerStructures((Structure[])new Structure[]{(Structure)TOWER.getFirst(), (Structure)SNOWY_TEMPLE.getFirst()});
        }
    }
}

