/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.features;

import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.DungeonsPlusLoot;
import com.legacy.structure_gel.structures.GelStructurePiece;
import com.legacy.structure_gel.structures.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.structures.jigsaw.JigsawRegistryHelper;
import com.legacy.structure_gel.structures.processors.RandomBlockSwapProcessor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;

public class BiggerDungeonPieces {
    public static void assemble(ChunkGenerator<?> chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed) {
        JigsawManager.func_214889_a((ResourceLocation)DungeonsPlus.locate("bigger_dungeon/root"), (int)7, Piece::new, chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed);
    }

    public static void init() {
    }

    static {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "bigger_dungeon/");
        registry.register("root", registry.builder().names(new String[]{"root"}).maintainWater(false).build());
        JigsawPoolBuilder basicPoolBuilder = registry.builder().maintainWater(false).processors(new StructureProcessor[]{new RandomBlockSwapProcessor(Blocks.field_150347_e, 0.2f, Blocks.field_150341_Y.func_176223_P())});
        registry.register("main_room", basicPoolBuilder.clone().names(new String[]{"main_room"}).build());
        JigsawPoolBuilder basicRooms = basicPoolBuilder.clone().weight(8).names(new String[]{"side_room/skeleton", "side_room/zombie"});
        JigsawPoolBuilder strayRoom = registry.builder().names(new String[]{"side_room/stray"}).maintainWater(false).processors(new StructureProcessor[]{new RandomBlockSwapProcessor(Blocks.field_150347_e, 0.2f, Blocks.field_150403_cj.func_176223_P())});
        JigsawPoolBuilder huskRoom = registry.builder().names(new String[]{"side_room/husk"}).maintainWater(false).processors(new StructureProcessor[]{new RandomBlockSwapProcessor(Blocks.field_150347_e, 0.2f, Blocks.field_150405_ch.func_176223_P())});
        registry.register("normal_room", JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{basicRooms, strayRoom, huskRoom}));
        registry.register("special_room", JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{strayRoom, huskRoom}));
    }

    public static class Piece
    extends GelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super((IStructurePieceType)DungeonsPlus.Features.BIGGER_DUNGEON.getSecond(), template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, (IStructurePieceType)DungeonsPlus.Features.BIGGER_DUNGEON.getSecond());
        }

        public void handleDataMarker(String key, IWorld worldIn, BlockPos pos, Random rand, MutableBoundingBox bounds) {
            String[] data;
            if (key.contains("chest")) {
                this.setAir(worldIn, pos);
                data = key.split("-");
                if (rand.nextBoolean() || data[0].contains("map")) {
                    worldIn.func_180501_a(pos, ((BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.func_176739_a((String)data[1]))).func_185907_a(this.field_214834_c), 3);
                    if (worldIn.func_175625_s(pos) instanceof ChestTileEntity) {
                        if (data[0].contains("huskmap")) {
                            ((ChestTileEntity)worldIn.func_175625_s(pos)).func_189404_a(DungeonsPlusLoot.DUNGEON_LOOT_HUSK, rand.nextLong());
                        } else if (data[0].contains("straymap")) {
                            ((ChestTileEntity)worldIn.func_175625_s(pos)).func_189404_a(DungeonsPlusLoot.DUNGEON_LOOT_STRAY, rand.nextLong());
                        } else {
                            ((ChestTileEntity)worldIn.func_175625_s(pos)).func_189404_a(LootTables.field_186422_d, rand.nextLong());
                        }
                    }
                }
            }
            if (key.contains("spawner")) {
                this.setAir(worldIn, pos);
                data = key.split("-");
                worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
                if (worldIn.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)worldIn.func_175625_s(pos)).func_145881_a().func_200876_a((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(data[1])));
                }
            }
        }
    }
}

