/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.DungeonsPlusLoot;
import com.legacy.structure_gel.structures.GelStructurePiece;
import com.legacy.structure_gel.structures.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.structures.jigsaw.JigsawRegistryHelper;
import com.legacy.structure_gel.structures.processors.RandomBlockSwapProcessor;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;

public class TowerPieces {
    public static void assemble(ChunkGenerator<?> chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed) {
        JigsawManager.func_214889_a((ResourceLocation)DungeonsPlus.locate("tower/root"), (int)7, Piece::new, chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed);
    }

    public static void init() {
    }

    static {
        RandomBlockSwapProcessor cobbleToMossy = new RandomBlockSwapProcessor(Blocks.field_150347_e, 0.2f, Blocks.field_150341_Y.func_176223_P());
        RandomBlockSwapProcessor goldDecay = new RandomBlockSwapProcessor(Blocks.field_150340_R, 0.3f, Blocks.field_150350_a.func_176223_P());
        RuleStructureProcessor brickDecay = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196696_di, 0.15f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196698_dj.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196696_di, 0.3f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196700_dk.func_176223_P())));
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "tower/");
        registry.register("root", registry.builder().names(new String[]{"root"}).build());
        registry.register("floor", registry.builder().names(new String[]{"floor_spider", "floor_zombie", "floor_skeleton"}).maintainWater(false).processors(new StructureProcessor[]{cobbleToMossy, brickDecay}).build());
        registry.register("floor_vex", registry.builder().names(new String[]{"floor_vex"}).maintainWater(false).processors(new StructureProcessor[]{cobbleToMossy, brickDecay}).build());
        registry.register("base", new JigsawPoolBuilder(registry).names(new String[]{"base"}).maintainWater(false).processors(new StructureProcessor[]{cobbleToMossy, brickDecay}).build());
        JigsawPoolBuilder topBuilder = registry.builder().maintainWater(false).processors(new StructureProcessor[]{cobbleToMossy});
        registry.register("top", JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{topBuilder.clone().names((Map)ImmutableMap.of((Object)"top_full", (Object)1)), topBuilder.clone().names((Map)ImmutableMap.of((Object)"top_decay", (Object)4)).processors(new StructureProcessor[]{goldDecay})}));
    }

    public static class Piece
    extends GelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super((IStructurePieceType)DungeonsPlus.Features.TOWER.getSecond(), template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, (IStructurePieceType)DungeonsPlus.Features.TOWER.getSecond());
        }

        public void handleDataMarker(String key, IWorld worldIn, BlockPos pos, Random rand, MutableBoundingBox bounds) {
            String[] data;
            if (key.contains("chest")) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                data = key.split("-");
                Direction facing = Direction.func_176739_a((String)data[1]);
                ChestType chestType = data[2].equals(ChestType.LEFT.func_176610_l()) ? ChestType.LEFT : (data[2].equals(ChestType.RIGHT.func_176610_l()) ? ChestType.RIGHT : ChestType.SINGLE);
                worldIn.func_180501_a(pos, ((BlockState)((BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)facing)).func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)chestType)).func_185907_a(this.field_214834_c), 3);
                if (worldIn.func_175625_s(pos) instanceof ChestTileEntity) {
                    if (data[0].contains("map")) {
                        ((ChestTileEntity)worldIn.func_175625_s(pos)).func_189404_a(DungeonsPlusLoot.TOWER_LOOT_MAP, rand.nextLong());
                    } else {
                        ((ChestTileEntity)worldIn.func_175625_s(pos)).func_189404_a(LootTables.field_186422_d, rand.nextLong());
                    }
                }
            }
            if (key.contains("spawner")) {
                this.setAir(worldIn, pos);
                data = key.split("-");
                worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
                if (worldIn.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                    ((MobSpawnerTileEntity)worldIn.func_175625_s(pos)).func_145881_a().func_200876_a((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(data[1])));
                }
            }
            if (key.equals("armor_stand")) {
                this.setAir(worldIn, pos);
                ArmorStandEntity entity = (ArmorStandEntity)this.createEntity(EntityType.field_200789_c, worldIn, pos, this.field_214834_c);
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151171_ah));
                for (Item item : ImmutableList.of((Object)Items.field_151169_ag, (Object)Items.field_151149_ai, (Object)Items.field_151151_aj)) {
                    if (!((double)rand.nextFloat() < 0.25)) continue;
                    entity.func_184201_a(MobEntity.func_184640_d((ItemStack)new ItemStack((IItemProvider)item)), new ItemStack((IItemProvider)item));
                }
                worldIn.func_217376_c((Entity)entity);
            }
        }
    }
}

