/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.pieces.SoulPrisonPieces;
import com.legacy.dungeons_plus.pieces.WarpedGardenPieces;
import com.legacy.dungeons_plus.pools.BiggerDungeonPools;
import com.legacy.dungeons_plus.pools.EndRuinsPools;
import com.legacy.dungeons_plus.pools.LeviathanPools;
import com.legacy.dungeons_plus.pools.SnowyTemplePools;
import com.legacy.dungeons_plus.pools.TowerPools;
import com.legacy.dungeons_plus.structures.BiggerDungeonStructure;
import com.legacy.dungeons_plus.structures.EndRuinsStructure;
import com.legacy.dungeons_plus.structures.LeviathanStructure;
import com.legacy.dungeons_plus.structures.SnowyTempleStructure;
import com.legacy.dungeons_plus.structures.SoulPrisonStructure;
import com.legacy.dungeons_plus.structures.TowerStructure;
import com.legacy.dungeons_plus.structures.WarpedGardenStructure;
import com.legacy.structure_gel.access_helpers.BiomeAccessHelper;
import com.legacy.structure_gel.access_helpers.JigsawAccessHelper;
import com.legacy.structure_gel.registrars.StructureRegistrar;
import com.mojang.serialization.Codec;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dungeons_plus")
public class DungeonsPlus {
    public static final String MODID = "dungeons_plus";
    public static final Logger LOGGER = LogManager.getLogger();

    public DungeonsPlus() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DPConfig.COMMON_SPEC);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(DungeonsPlus::biomeLoad);
    }

    protected static void biomeLoad(BiomeLoadingEvent event) {
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.TOWER.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.BIGGER_DUNGEON.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.LEVIATHAN.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.SNOWY_TEMPLE.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.END_RUINS.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.WARPED_GARDEN.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)Structures.SOUL_PRISON.getStructureFeature());
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Structures {
        public static StructureRegistrar<VillageConfig, TowerStructure> TOWER = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("tower"), (Structure)new TowerStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_, DPConfig.COMMON.tower), TowerStructure.Piece::new, (IFeatureConfig)new VillageConfig(() -> TowerPools.ROOT, 7), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
        public static StructureRegistrar<VillageConfig, BiggerDungeonStructure> BIGGER_DUNGEON = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("bigger_dungeon"), (Structure)new BiggerDungeonStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_, DPConfig.COMMON.biggerDungeon), BiggerDungeonStructure.Piece::new, (IFeatureConfig)new VillageConfig(() -> BiggerDungeonPools.ROOT, 7), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
        public static StructureRegistrar<VillageConfig, LeviathanStructure> LEVIATHAN = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("leviathan"), (Structure)new LeviathanStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_, DPConfig.COMMON.leviathan), LeviathanStructure.Piece::new, (IFeatureConfig)new VillageConfig(() -> LeviathanPools.ROOT, 7), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
        public static StructureRegistrar<VillageConfig, SnowyTempleStructure> SNOWY_TEMPLE = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("snowy_temple"), (Structure)new SnowyTempleStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_, DPConfig.COMMON.snowyTemple), SnowyTempleStructure.Piece::new, (IFeatureConfig)new VillageConfig(() -> SnowyTemplePools.ROOT, 7), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
        public static StructureRegistrar<VillageConfig, EndRuinsStructure> END_RUINS = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("end_ruins"), (Structure)new EndRuinsStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_, DPConfig.COMMON.endRuins), EndRuinsStructure.Piece::new, (IFeatureConfig)new VillageConfig(() -> EndRuinsPools.ROOT, 7), (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
        public static StructureRegistrar<NoFeatureConfig, WarpedGardenStructure> WARPED_GARDEN = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("warped_garden"), (Structure)new WarpedGardenStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, DPConfig.COMMON.warpedGarden), WarpedGardenPieces.Piece::new, (IFeatureConfig)NoFeatureConfig.field_202429_e, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
        public static StructureRegistrar<NoFeatureConfig, SoulPrisonStructure> SOUL_PRISON = StructureRegistrar.of((ResourceLocation)DungeonsPlus.locate("soul_prison"), (Structure)new SoulPrisonStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, DPConfig.COMMON.soulPrison), SoulPrisonPieces.Piece::new, (IFeatureConfig)NoFeatureConfig.field_202429_e, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();

        @SubscribeEvent
        protected static void onRegistry(RegistryEvent.Register<Structure<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            TOWER.handleForge(registry);
            BIGGER_DUNGEON.handleForge(registry);
            LEVIATHAN.handleForge(registry);
            SNOWY_TEMPLE.handleForge(registry);
            END_RUINS.handleForge(registry);
            WARPED_GARDEN.handleForge(registry);
            SOUL_PRISON.handleForge(registry);
            JigsawAccessHelper.addIllagerStructures((Structure[])new Structure[]{TOWER.getStructure(), SNOWY_TEMPLE.getStructure()});
            TowerPools.init();
            BiggerDungeonPools.init();
            LeviathanPools.init();
            SnowyTemplePools.init();
            EndRuinsPools.init();
        }
    }
}

