/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.pieces;

import com.google.common.collect.ImmutableList;
import com.legacy.dungeons_plus.DPLoot;
import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.access_helpers.SpawnerAccessHelper;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.worldgen.processors.RandomStateSwapProcessor;
import com.legacy.structure_gel.worldgen.structure.GelTemplateStructurePiece;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SoulPrisonPieces {
    private static final ResourceLocation TOP = SoulPrisonPieces.locate("main/top_0");
    private static final ResourceLocation TOP_GEL = SoulPrisonPieces.locate("main/top_gel");
    private static final ResourceLocation[] BOTTOM = new ResourceLocation[]{SoulPrisonPieces.locate("main/bottom_0")};
    private static final ResourceLocation UNDER_MAIN = SoulPrisonPieces.locate("main/under");
    private static final ResourceLocation[] TURRETS = new ResourceLocation[]{SoulPrisonPieces.locate("turrets/turret_0"), SoulPrisonPieces.locate("turrets/turret_1")};

    public static void assemble(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces, Random rand) {
        pos = pos.func_177982_a(-12, 0, -12);
        structurePieces.add((StructurePiece)new Piece(templateManager, (ResourceLocation)Util.func_240989_a_((Object[])BOTTOM, (Random)rand), pos, rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, TOP_GEL, pos.func_177981_b(11), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, TOP, pos.func_177981_b(11), rotation));
        for (int i = 1; i < pos.func_177956_o(); ++i) {
            structurePieces.add((StructurePiece)new Piece(templateManager, UNDER_MAIN, pos.func_177979_c(i), rotation, 1));
        }
        pos = pos.func_177982_a(12, 0, 12);
        int range = 32;
        structurePieces.add((StructurePiece)new Piece(templateManager, (ResourceLocation)Util.func_240989_a_((Object[])TURRETS, (Random)rand), pos.func_177982_a(range, 0, rand.nextInt(20) - 10), Rotation.func_222466_a((Random)rand)));
        structurePieces.add((StructurePiece)new Piece(templateManager, (ResourceLocation)Util.func_240989_a_((Object[])TURRETS, (Random)rand), pos.func_177982_a(-range, 0, rand.nextInt(20) - 10), Rotation.func_222466_a((Random)rand)));
        structurePieces.add((StructurePiece)new Piece(templateManager, (ResourceLocation)Util.func_240989_a_((Object[])TURRETS, (Random)rand), pos.func_177982_a(rand.nextInt(20) - 10, 0, range), Rotation.func_222466_a((Random)rand)));
        structurePieces.add((StructurePiece)new Piece(templateManager, (ResourceLocation)Util.func_240989_a_((Object[])TURRETS, (Random)rand), pos.func_177982_a(rand.nextInt(20) - 10, 0, -range), Rotation.func_222466_a((Random)rand)));
    }

    private static ResourceLocation locate(String name) {
        return DungeonsPlus.locate("soul_prison/" + name);
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation, int componentType) {
            super(DungeonsPlus.Structures.SOUL_PRISON.getPieceType(), location, componentType);
            this.field_186178_c = pos;
            this.field_186169_c = rotation;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            this(templateManager, location, pos, rotation, 0);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbtCompound) {
            super(DungeonsPlus.Structures.SOUL_PRISON.getPieceType(), nbtCompound);
            this.setupTemplate(templateManager);
        }

        public PlacementSettings createPlacementSettings(TemplateManager templateManager) {
            BlockPos sizePos = templateManager.func_200219_b(this.name).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            return new GelPlacementSettings().setMaintainWater(false).func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a(centerPos);
        }

        public void addProcessors(TemplateManager templateManager, PlacementSettings placementSettings) {
            super.addProcessors(templateManager, placementSettings);
            placementSettings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_235395_nI_, 0.1f, Blocks.field_196772_fk));
            placementSettings.func_215222_a((StructureProcessor)new RandomStateSwapProcessor((BlockState)Blocks.field_235338_cP_.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y), 0.55f, (BlockState)Blocks.field_235337_cO_.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y)));
            placementSettings.func_215222_a((StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196576_bD), (RuleTest)new BlockMatchRuleTest(Blocks.field_150353_l), Blocks.field_150353_l.func_176223_P()))));
            placementSettings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196808_gk, Blocks.field_150353_l));
        }

        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            BlockState worldState = world.func_180495_p(pos);
            if (this.field_74886_g == 1 && worldState.func_177230_c() != Blocks.field_150353_l && worldState.func_185904_a() != Material.field_151579_a) {
                return null;
            }
            return originalState;
        }

        protected void func_186175_a(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            if (key.equals("guard")) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                WitherSkeletonEntity wither = (WitherSkeletonEntity)EntityType.field_200722_aA.func_200721_a((World)world.func_201672_e());
                wither.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                wither.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151020_U));
                wither.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151023_V));
                wither.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
                wither.func_110163_bv();
                world.func_217376_c((Entity)wither);
            } else if (key.equals("ghast")) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                GhastEntity ghast = (GhastEntity)EntityType.field_200811_y.func_200721_a((World)world.func_201672_e());
                ghast.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                ghast.func_110163_bv();
                world.func_217376_c((Entity)ghast);
            } else if (key.equals("spawner")) {
                DPUtil.placeSpawner(EntityType.field_200811_y, (IWorld)world, pos);
                if (world.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                    MobSpawnerTileEntity tile = (MobSpawnerTileEntity)world.func_175625_s(pos);
                    SpawnerAccessHelper.setRequiredPlayerRange((MobSpawnerTileEntity)tile, (int)32);
                    SpawnerAccessHelper.setMaxNearbyEntities((MobSpawnerTileEntity)tile, (int)10);
                    SpawnerAccessHelper.setSpawnCount((MobSpawnerTileEntity)tile, (int)5);
                    SpawnerAccessHelper.setSpawnRange((MobSpawnerTileEntity)tile, (int)16);
                }
            } else if (key.contains("chest")) {
                DPUtil.placeLootChest(DPLoot.SoulPrison.CHEST_COMMON, (IWorld)world, rand, pos, this.field_186169_c, key.split("-")[1]);
            }
        }
    }
}

