/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures;

import com.legacy.dungeons_plus.DPLoot;
import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class BiggerDungeonStructure
extends GelConfigJigsawStructure {
    public BiggerDungeonStructure(Codec<VillageConfig> codec, ConfigTemplates.StructureConfig config) {
        super(codec, config, 20, true, false);
    }

    public int getSeed() {
        return 973181;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static final class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager templateManager, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox bounds) {
            super(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(templateManager, nbt);
        }

        public IStructurePieceType func_214807_k() {
            return DungeonsPlus.Structures.BIGGER_DUNGEON.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            String[] data;
            if (key.contains("chest")) {
                this.setAir((IWorld)world, pos);
                data = key.split("-");
                if (rand.nextBoolean() || data[0].contains("map")) {
                    ResourceLocation lootTable = DPLoot.CHESTS_SIMPLE_DUNGEON;
                    if (data[0].contains(":")) {
                        switch (data[0].split(":")[1]) {
                            case "huskmap": {
                                lootTable = DPLoot.BiggerDungeon.CHEST_HUSK_MAP;
                                break;
                            }
                            case "husk": {
                                lootTable = DPLoot.BiggerDungeon.CHEST_HUSK;
                                break;
                            }
                            case "straymap": {
                                lootTable = DPLoot.BiggerDungeon.CHEST_STRAY_MAP;
                                break;
                            }
                            case "stray": {
                                lootTable = DPLoot.BiggerDungeon.CHEST_STRAY;
                            }
                        }
                    }
                    DPUtil.placeLootChest(lootTable, (IWorld)world, rand, pos, this.field_214834_c, data[1]);
                }
            }
            if (key.contains("spawner")) {
                data = key.split("-");
                DPUtil.placeSpawner(data[1], (IWorld)world, pos);
            }
        }
    }
}

