/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures;

import com.google.common.collect.ImmutableList;
import com.legacy.dungeons_plus.DPLoot;
import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LeviathanStructure
extends GelConfigJigsawStructure {
    public LeviathanStructure(Codec<VillageConfig> codec, ConfigTemplates.StructureConfig config) {
        super(codec, config, -1, true, true);
        this.setSpawnList(EntityClassification.MONSTER, (List)ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200763_C, 1, 4, 4)));
    }

    public int getSeed() {
        return 719643;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt);
        }

        public IStructurePieceType func_214807_k() {
            return DungeonsPlus.Structures.LEVIATHAN.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            if (key.contains("chest")) {
                String[] data = key.split("-");
                DPUtil.placeLootChest(DPLoot.Leviathan.CHEST_COMMON, (IWorld)world, rand, pos, this.field_214834_c, data[1]);
            }
            if (key.equals("spawner")) {
                DPUtil.placeSpawner(EntityType.field_200763_C, (IWorld)world, pos);
            }
        }
    }
}

