/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.entity.EntityUtils;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easy_villagers.corelib.net.NetUtils;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.net.MessageVillagerParticles;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BreederTileentity
extends FakeWorldTileentity
implements ITickableTileEntity {
    private NonNullList<ItemStack> foodInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> outputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private ItemStack villager1 = ItemStack.field_190927_a;
    private VillagerEntity villagerEntity1;
    private ItemStack villager2 = ItemStack.field_190927_a;
    private VillagerEntity villagerEntity2;
    private IItemHandlerModifiable foodInventoryHandler;
    private IItemHandlerModifiable outputInventoryHandler;

    public BreederTileentity() {
        super(ModTileEntities.BREEDER);
    }

    public ItemStack getVillager1() {
        return this.villager1;
    }

    public ItemStack getVillager2() {
        return this.villager2;
    }

    public boolean hasVillager1() {
        return !this.villager1.func_190926_b();
    }

    public boolean hasVillager2() {
        return !this.villager2.func_190926_b();
    }

    public VillagerEntity getVillagerEntity1() {
        if (this.villagerEntity1 == null && !this.villager1.func_190926_b()) {
            this.villagerEntity1 = ModItems.VILLAGER.getVillager(this.field_145850_b, this.villager1);
        }
        return this.villagerEntity1;
    }

    public VillagerEntity getVillagerEntity2() {
        if (this.villagerEntity2 == null && !this.villager2.func_190926_b()) {
            this.villagerEntity2 = ModItems.VILLAGER.getVillager(this.field_145850_b, this.villager2);
        }
        return this.villagerEntity2;
    }

    public void setVillager1(ItemStack villager) {
        this.villager1 = villager;
        this.villagerEntity1 = villager.func_190926_b() ? null : ModItems.VILLAGER.getVillager(this.field_145850_b, villager);
        this.func_70296_d();
        this.sync();
    }

    public void setVillager2(ItemStack villager) {
        this.villager2 = villager;
        this.villagerEntity2 = villager.func_190926_b() ? null : ModItems.VILLAGER.getVillager(this.field_145850_b, villager);
        this.func_70296_d();
        this.sync();
    }

    public ItemStack removeVillager1() {
        ItemStack v = this.villager1;
        this.setVillager1(ItemStack.field_190927_a);
        return v;
    }

    public ItemStack removeVillager2() {
        ItemStack v = this.villager2;
        this.setVillager2(ItemStack.field_190927_a);
        return v;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean age1 = VillagerTileentity.advanceAge(this.getVillagerEntity1());
        boolean age2 = VillagerTileentity.advanceAge(this.getVillagerEntity2());
        if (age1 || age2) {
            this.sync();
        }
        if (this.hasVillager1() || this.hasVillager2()) {
            this.func_70296_d();
        }
        if (this.field_145850_b.func_82737_E() % (long)((Integer)Main.SERVER_CONFIG.breedingTime.get()).intValue() == 0L) {
            this.tryBreed();
        }
    }

    public void tryBreed() {
        if (this.canBreed() && this.addVillager()) {
            this.removeBreedingItems();
            TraderBlock.playVillagerSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_219721_mv);
            this.spawnParticles();
        }
    }

    public void spawnParticles() {
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197633_z, (double)this.field_174879_c.func_177958_n() + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) + 0.5, (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() + 1.0, (double)this.field_174879_c.func_177952_p() + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) + 0.5, 0.0, 0.0, 0.0);
            }
        } else {
            MessageVillagerParticles msg = new MessageVillagerParticles(this.field_174879_c);
            EntityUtils.forEachPlayerAround((ServerWorld)this.field_145850_b, this.field_174879_c, 128.0, playerEntity -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, playerEntity, msg));
        }
    }

    private boolean addVillager() {
        for (int i = 0; i < this.outputInventory.size(); ++i) {
            if (!((ItemStack)this.outputInventory.get(i)).func_190926_b()) continue;
            VillagerEntity villagerEntity = new VillagerEntity(EntityType.field_200756_av, this.field_145850_b);
            villagerEntity.func_213753_a(villagerEntity.func_213700_eh().func_221134_a(VillagerType.func_242371_a((Optional)this.field_145850_b.func_242406_i(this.func_174877_v()))));
            villagerEntity.func_70873_a(-24000);
            ItemStack villager = new ItemStack((IItemProvider)ModItems.VILLAGER);
            ModItems.VILLAGER.setVillager(villager, villagerEntity);
            this.outputInventory.set(i, (Object)villager);
            return true;
        }
        return false;
    }

    public boolean canBreed() {
        if (!this.hasVillager1() || !this.hasVillager2()) {
            return false;
        }
        if (this.getVillagerEntity1().func_70631_g_() || this.getVillagerEntity2().func_70631_g_()) {
            return false;
        }
        int value = 0;
        for (ItemStack stack : this.foodInventory) {
            value += VillagerEntity.field_213788_bA.getOrDefault(stack.func_77973_b(), 0) * stack.func_190916_E();
        }
        return value >= 24;
    }

    private void removeBreedingItems() {
        int value = 0;
        for (ItemStack stack : this.foodInventory) {
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                stack.func_190918_g(1);
                if ((value += VillagerEntity.field_213788_bA.getOrDefault(stack.func_77973_b(), 0).intValue()) < 24) continue;
                return;
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT comp;
        if (this.hasVillager1()) {
            comp = new CompoundNBT();
            if (this.villagerEntity1 != null) {
                ModItems.VILLAGER.setVillager(this.villager1, this.villagerEntity1);
            }
            this.villager1.func_77955_b(comp);
            compound.func_218657_a("Villager1", (INBT)comp);
        }
        if (this.hasVillager2()) {
            comp = new CompoundNBT();
            if (this.villagerEntity2 != null) {
                ModItems.VILLAGER.setVillager(this.villager2, this.villagerEntity2);
            }
            this.villager2.func_77955_b(comp);
            compound.func_218657_a("Villager2", (INBT)comp);
        }
        compound.func_218657_a("FoodInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.foodInventory, (boolean)true));
        compound.func_218657_a("OutputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.outputInventory, (boolean)true));
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        CompoundNBT comp;
        if (compound.func_74764_b("Villager1")) {
            comp = compound.func_74775_l("Villager1");
            this.villager1 = ItemStack.func_199557_a((CompoundNBT)comp);
            this.villagerEntity1 = null;
        } else {
            this.removeVillager1();
        }
        if (compound.func_74764_b("Villager2")) {
            comp = compound.func_74775_l("Villager2");
            this.villager2 = ItemStack.func_199557_a((CompoundNBT)comp);
            this.villagerEntity2 = null;
        } else {
            this.removeVillager2();
        }
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("FoodInventory"), this.foodInventory);
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("OutputInventory"), this.outputInventory);
        super.func_230337_a_(state, compound);
    }

    public IInventory getFoodInventory() {
        return new ItemListInventory(this.foodInventory, () -> ((BreederTileentity)this).func_70296_d());
    }

    public IInventory getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BreederTileentity)this).func_70296_d());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null && side.equals((Object)Direction.DOWN)) {
                return LazyOptional.of(this::getOutputInventoryItemHandler).cast();
            }
            return LazyOptional.of(this::getFoodInventoryItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getFoodInventoryItemHandler() {
        if (this.foodInventoryHandler == null) {
            this.foodInventoryHandler = new ItemStackHandler(this.foodInventory);
        }
        return this.foodInventoryHandler;
    }

    public IItemHandlerModifiable getOutputInventoryItemHandler() {
        if (this.outputInventoryHandler == null) {
            this.outputInventoryHandler = new ItemStackHandler(this.outputInventory);
        }
        return this.outputInventoryHandler;
    }
}

