/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class IncubatorTileentity
extends VillagerTileentity
implements ITickableTileEntity {
    private NonNullList<ItemStack> inputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> outputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private IItemHandlerModifiable foodInventoryHandler;
    private IItemHandlerModifiable outputInventoryHandler;

    public IncubatorTileentity() {
        super(ModTileEntities.INCUBATOR);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.hasVillager()) {
            for (ItemStack stack : this.inputInventory) {
                if (!(stack.func_77973_b() instanceof VillagerItem)) continue;
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                this.setVillager(copy);
                stack.func_190918_g(1);
                this.sync();
                break;
            }
        }
        if (this.hasVillager()) {
            VillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity.func_70631_g_()) {
                if (this.advanceAge(Math.min((Integer)Main.SERVER_CONFIG.incubatorSpeed.get(), Math.abs(villagerEntity.func_70874_b())))) {
                    this.sync();
                }
            } else {
                this.advanceAge(1);
            }
            if (villagerEntity.func_70874_b() > 20) {
                for (int i = 0; i < this.outputInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.outputInventory.get(i);
                    if (!stack.func_190926_b()) continue;
                    this.outputInventory.set(i, (Object)this.removeVillager().func_77946_l());
                    this.sync();
                    break;
                }
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("InputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.inputInventory, (boolean)true));
        compound.func_218657_a("OutputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.outputInventory, (boolean)true));
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("InputInventory"), this.inputInventory);
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("OutputInventory"), this.outputInventory);
        super.func_230337_a_(state, compound);
    }

    public IInventory getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((IncubatorTileentity)this).func_70296_d());
    }

    public IInventory getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((IncubatorTileentity)this).func_70296_d());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null && side.equals((Object)Direction.DOWN)) {
                return LazyOptional.of(this::getOutputInventoryItemHandler).cast();
            }
            return LazyOptional.of(this::getInputInventoryItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getInputInventoryItemHandler() {
        if (this.foodInventoryHandler == null) {
            this.foodInventoryHandler = new ItemStackHandler(this.inputInventory);
        }
        return this.foodInventoryHandler;
    }

    public IItemHandlerModifiable getOutputInventoryItemHandler() {
        if (this.outputInventoryHandler == null) {
            this.outputInventoryHandler = new ItemStackHandler(this.outputInventory);
        }
        return this.outputInventoryHandler;
    }
}

