/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class IronFarmTileentity
extends VillagerTileentity
implements ITickableTileEntity {
    private static final ResourceLocation GOLEM_LOOT_TABLE = new ResourceLocation("entities/iron_golem");
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private long timer;
    private IItemHandlerModifiable handler;

    public IronFarmTileentity() {
        super(ModTileEntities.IRON_FARM);
    }

    public long getTimer() {
        return this.timer;
    }

    public void func_73660_a() {
        VillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                    TraderBlock.playVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187910_gj);
                }
                if (this.field_145850_b.field_73012_v.nextInt(40) == 0) {
                    TraderBlock.playVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187899_gZ);
                }
            }
            if (this.advanceAge()) {
                this.sync();
            }
            ++this.timer;
            this.func_70296_d();
            if (this.timer == (long)IronFarmTileentity.getGolemSpawnTime()) {
                TraderBlock.playVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187899_gZ);
                this.sync();
            } else if (this.timer > (long)IronFarmTileentity.getGolemSpawnTime() && this.timer < (long)IronFarmTileentity.getGolemKillTime()) {
                if (this.timer % 20L == 0L) {
                    TraderBlock.playVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187602_cF);
                }
            } else if (this.timer >= (long)IronFarmTileentity.getGolemKillTime()) {
                TraderBlock.playVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187599_cE);
                IItemHandlerModifiable itemHandler = this.getItemHandler();
                for (ItemStack drop : this.getDrops()) {
                    for (int i = 0; i < itemHandler.getSlots() && !(drop = itemHandler.insertItem(i, drop, false)).func_190926_b(); ++i) {
                    }
                }
                this.timer = 0L;
                this.sync();
            }
        }
    }

    private List<ItemStack> getDrops() {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return Collections.emptyList();
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(serverWorld.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)new IronGolemEntity(EntityType.field_200757_aw, this.field_145850_b)).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p())).func_216015_a(LootParameters.field_216283_c, (Object)DamageSource.field_76371_c);
        LootContext lootContext = builder.func_216022_a(LootParameterSets.field_216263_d);
        LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(GOLEM_LOOT_TABLE);
        return lootTable.func_216113_a(lootContext);
    }

    public IInventory getOutputInventory() {
        return new ItemListInventory(this.inventory, () -> ((IronFarmTileentity)this).func_70296_d());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)false);
        compound.func_74772_a("Timer", this.timer);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        this.timer = compound.func_74763_f("Timer");
        super.func_230337_a_(state, compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        if (this.handler == null) {
            this.handler = new ItemStackHandler(this.inventory);
        }
        return this.handler;
    }

    public static int getGolemSpawnTime() {
        return (Integer)Main.SERVER_CONFIG.golemSpawnTime.get() - 200;
    }

    public static int getGolemKillTime() {
        return IronFarmTileentity.getGolemSpawnTime() + 200;
    }
}

