/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.integration.jei;

import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.integration.jei.breeder.BreederCategory;
import de.maxhenkel.easyvillagers.integration.jei.converter.ConverterCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation CATEGORY_BREEDING = new ResourceLocation("easy_villagers", "breeding");
    public static final ResourceLocation CATEGORY_CONVERTING = new ResourceLocation("easy_villagers", "converting");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("easy_villagers", "easy_villagers");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BREEDER), new ResourceLocation[]{CATEGORY_BREEDING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CONVERTER), new ResourceLocation[]{CATEGORY_CONVERTING});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BreederCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ConverterCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Collection foods = VillagerEntity.field_213788_bA.entrySet().stream().map(itemIntegerEntry -> new ItemStack((IItemProvider)itemIntegerEntry.getKey(), (int)Math.ceil(24.0 / (double)((Integer)itemIntegerEntry.getValue()).intValue()))).collect(Collectors.toList());
        registration.addRecipes(foods, CATEGORY_BREEDING);
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185226_I));
        potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185227_J));
        potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185226_I));
        potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185227_J));
        potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185226_I));
        potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185227_J));
        registration.addRecipes(potions, CATEGORY_CONVERTING);
    }
}

