/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.integration.waila;

import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.ConverterTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.FarmerTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.IncubatorTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.IronFarmTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentity;
import de.maxhenkel.easyvillagers.integration.waila.HUDHandlerBreeder;
import de.maxhenkel.easyvillagers.integration.waila.HUDHandlerConverter;
import de.maxhenkel.easyvillagers.integration.waila.HUDHandlerVillager;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

@WailaPlugin
public class PluginEasyVillagers
implements IWailaPlugin {
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation CONFIG_SHOW_REGISTRY = new ResourceLocation("waila", "show_registry");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");

    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)HUDHandlerVillager.INSTANCE, TooltipPosition.BODY, TraderTileentity.class);
        registrar.registerComponentProvider((IComponentProvider)HUDHandlerVillager.INSTANCE, TooltipPosition.BODY, IronFarmTileentity.class);
        registrar.registerComponentProvider((IComponentProvider)HUDHandlerVillager.INSTANCE, TooltipPosition.BODY, FarmerTileentity.class);
        registrar.registerComponentProvider((IComponentProvider)HUDHandlerVillager.INSTANCE, TooltipPosition.BODY, IncubatorTileentity.class);
        registrar.registerComponentProvider((IComponentProvider)HUDHandlerConverter.INSTANCE, TooltipPosition.BODY, ConverterTileentity.class);
        registrar.registerComponentProvider((IComponentProvider)HUDHandlerBreeder.INSTANCE, TooltipPosition.BODY, BreederTileentity.class);
    }

    public static IFormattableTextComponent getVillagerName(VillagerProfession profession) {
        return new TranslationTextComponent("entity.minecraft.villager." + profession);
    }

    @Nullable
    public static ITextComponent getVillager(VillagerEntity villager) {
        if (villager != null) {
            if (villager.func_145818_k_()) {
                return villager.func_200201_e();
            }
            VillagerData villagerData = villager.func_213700_eh();
            VillagerProfession profession = villagerData.func_221130_b();
            if (profession.equals(VillagerProfession.field_221151_a) || profession.equals(VillagerProfession.field_221162_l)) {
                return PluginEasyVillagers.getVillagerName(profession).func_240699_a_(TextFormatting.GRAY);
            }
            return new TranslationTextComponent("tooltip.easy_villagers.villager_profession", new Object[]{PluginEasyVillagers.getVillagerName(profession), new TranslationTextComponent("merchant.level." + villagerData.func_221132_c())}).func_240699_a_(TextFormatting.GRAY);
        }
        return null;
    }
}

