/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items;

import de.maxhenkel.easy_villagers.corelib.CachedMap;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.items.render.VillagerItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VillagerItem
extends Item {
    private CachedMap<ItemStack, VillagerEntity> cachedVillagers = new CachedMap(10000L);

    public VillagerItem() {
        super(new Item.Properties().func_200917_a(1).setISTER(() -> VillagerItemRenderer::new));
        DispenserBlock.func_199774_a((IItemProvider)this, (source, stack) -> {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
            ServerWorld world = source.func_197524_h();
            VillagerEntity villager = this.getVillager((World)world, stack);
            villager.func_70080_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, direction.func_185119_l(), 0.0f);
            world.func_217376_c((Entity)villager);
            stack.func_190918_g(1);
            return stack;
        });
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (!blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b()) {
            blockpos = blockpos.func_177972_a(direction);
        }
        VillagerEntity villager = this.getVillager(world, itemstack);
        villager.func_70107_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
        if (world.func_217376_c((Entity)villager)) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200295_i(ItemStack stack) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return super.func_200295_i(stack);
        }
        VillagerEntity villager = this.getVillagerFast((World)world, stack);
        if (!villager.func_145818_k_() && villager.func_70631_g_()) {
            return new TranslationTextComponent("item.easy_villagers.baby_villager");
        }
        return villager.func_145748_c_();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof PlayerEntity) || world.field_72995_K) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.villagerInventorySounds.get()).booleanValue()) {
            return;
        }
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        if (world.field_73012_v.nextInt(20) == 0) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            playerEntity.func_213823_a(SoundEvents.field_187910_gj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void setVillager(ItemStack stack, VillagerEntity villager) {
        CompoundNBT compound = stack.func_190925_c("villager");
        villager.func_213281_b(compound);
        if (villager.func_145818_k_()) {
            stack.func_200302_a(villager.func_200201_e());
        }
    }

    public VillagerEntity getVillager(World world, ItemStack stack) {
        CompoundNBT compound = stack.func_179543_a("villager");
        if (compound == null) {
            compound = new CompoundNBT();
        }
        VillagerEntity villager = new VillagerEntity(EntityType.field_200756_av, world);
        villager.func_70037_a(compound);
        if (stack.func_82837_s()) {
            villager.func_200203_b(stack.func_200301_q());
        }
        villager.field_70737_aN = 0;
        return villager;
    }

    public VillagerEntity getVillagerFast(World world, ItemStack stack) {
        return this.cachedVillagers.get(stack, () -> this.getVillager(world, stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getBabyVillager() {
        ItemStack babyVillager = new ItemStack((IItemProvider)ModItems.VILLAGER);
        VillagerEntity villager = new VillagerEntity(EntityType.field_200756_av, (World)Minecraft.func_71410_x().field_71441_e){

            public int func_70874_b() {
                return -24000;
            }
        };
        ModItems.VILLAGER.setVillager(babyVillager, villager);
        return babyVillager;
    }
}

