/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs;

import com.eractnod.ediblebugs.config.Config;
import com.eractnod.ediblebugs.proxy.ClientProxy;
import com.eractnod.ediblebugs.proxy.IProxy;
import com.eractnod.ediblebugs.proxy.ServerProxy;
import com.eractnod.ediblebugs.recipe.AllRecipes;
import com.eractnod.ediblebugs.setup.EdiblebugsSetup;
import com.eractnod.ediblebugs.setup.ModSetup;
import com.eractnod.ediblebugs.worldgen.TermiteMoundGen;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ediblebugs")
public class Ediblebugs {
    public static final String MODID = "ediblebugs";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static ModSetup setup = new ModSetup();
    private static final Logger LOGGER = LogManager.getLogger();

    public Ediblebugs() {
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("ediblebugs-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("ediblebugs-common.toml"));
        EdiblebugsSetup.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(RecipeSerializer.class, Ediblebugs::registerRecipes);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, TermiteMoundGen::onLoadEvent);
    }

    public static void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        AllRecipes.register(event);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("EdibleBugs preinit");
        proxy.setup();
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("EdibleBugs from server starting");
    }
}

