/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.loot;

import com.eractnod.ediblebugs.config.EdiblebugsConfig;
import com.eractnod.ediblebugs.setup.EdiblebugsSetup;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class GrassBlockConverterModifier
extends LootModifier {
    private List<ItemStack> bugDrops = new ArrayList<ItemStack>();

    protected GrassBlockConverterModifier(LootItemCondition[] conditionsIn, List<String> bugs) {
        super(conditionsIn);
        for (String bug : bugs) {
            this.addEntry(bug, 20);
        }
    }

    private void addEntry(String bug, int weight) {
        ResourceLocation location = new ResourceLocation(bug);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
        this.bugDrops.add(new ItemStack((ItemLike)item));
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)EdiblebugsConfig.ALLOWDIRTBUGS.get()).booleanValue() && this.bugDrops.get(0).m_150930_((Item)EdiblebugsSetup.FIREANT.get())) {
            return generatedLoot;
        }
        if (!((Boolean)EdiblebugsConfig.ALLOWSANDBUGS.get()).booleanValue() && this.bugDrops.get(0).m_150930_((Item)EdiblebugsSetup.CAMELSPIDER.get())) {
            return generatedLoot;
        }
        if (!((Boolean)EdiblebugsConfig.ALLOWGRASSBUGS.get()).booleanValue() && this.bugDrops.get(0).m_150930_((Item)EdiblebugsSetup.GRASSHOPPER.get())) {
            return generatedLoot;
        }
        if (!((Boolean)EdiblebugsConfig.ALLOWWOODBUGS.get()).booleanValue() && this.bugDrops.get(0).m_150930_((Item)EdiblebugsSetup.WOODTERMITE.get())) {
            return generatedLoot;
        }
        generatedLoot.add(this.bugDrops.get(context.m_78933_().nextInt(4)));
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GrassBlockConverterModifier> {
        public GrassBlockConverterModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            ArrayList<String> bugs = new ArrayList<String>();
            JsonArray buglist = GsonHelper.m_13933_((JsonObject)object, (String)"bugs");
            for (JsonElement je : buglist) {
                bugs.add(je.getAsString());
            }
            return new GrassBlockConverterModifier(ailootcondition, bugs);
        }

        public JsonObject write(GrassBlockConverterModifier instance) {
            return new JsonObject();
        }
    }
}

