/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.modules.bugzapper;

import com.eractnod.ediblebugs.blocks.TermiteBlockA;
import com.eractnod.ediblebugs.modules.bugzapper.BugZapperContainer;
import com.eractnod.ediblebugs.setup.EdiblebugsSetup;
import com.eractnod.ediblebugs.setup.ModBlocks;
import com.eractnod.ediblebugs.util.EBFakePlayerFactory;
import com.eractnod.ediblebugs.util.ItemUtil;
import com.eractnod.ediblebugs.util.TickerUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class BugZapperTile
extends BaseContainerBlockEntity
implements TickerUtil.TickableServer,
MenuProvider,
WorldlyContainer {
    private static final int[] SLOTS_TOP = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] SLOTS_BOTTOM = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final int[] SLOTS_SIDES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private NonNullList<ItemStack> zapperItemStacks = NonNullList.m_122780_((int)17, (Object)ItemStack.f_41583_);
    private Component name;
    private int timer = 100;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public BugZapperTile(BlockPos pos, BlockState state) {
        super(ModBlocks.BUGZAPPER_TILE, pos, state);
    }

    @Override
    public void updateServer() {
        --this.timer;
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46753_(this.f_58858_)) {
            if (this.timer < 0) {
                this.setDirtBlock();
                this.m_6596_();
                this.timer = 100;
            }
            this.clickLarveOnDirtBlock();
            this.breakTermiteMound();
            this.doHoover();
        }
    }

    private void doHoover() {
        AABB axis = new AABB(this.f_58858_, this.f_58858_).m_82400_(9.0);
        List listItem = this.f_58857_.m_45976_(ItemEntity.class, axis);
        for (ItemEntity entity : listItem) {
            this.hooverEntity(entity);
        }
    }

    private void hooverEntity(ItemEntity entity) {
        if (!this.f_58857_.f_46443_) {
            int numInserted = 0;
            if (entity instanceof ItemEntity && entity.m_6084_()) {
                ItemEntity item = entity;
                ItemStack stack = item.m_32055_().m_41777_();
                numInserted = stack.m_41720_() == EdiblebugsSetup.TERMITELARVA.get() ? ItemUtil.doInsertItem(this, 4, 17, stack) : ItemUtil.doInsertItem(this, 8, 17, stack);
                stack.m_41774_(numInserted);
                item.m_32045_(stack);
                if (stack.m_41613_() == 0) {
                    item.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        }
    }

    private void breakTermiteMound() {
        Block blockNorth = this.f_58857_.m_8055_(this.f_58858_.m_142390_(3)).m_60734_();
        Block blockSouth = this.f_58857_.m_8055_(this.f_58858_.m_142383_(3)).m_60734_();
        Block blockEast = this.f_58857_.m_8055_(this.f_58858_.m_142385_(3)).m_60734_();
        Block blockWest = this.f_58857_.m_8055_(this.f_58858_.m_142386_(3)).m_60734_();
        Block blockMound = ModBlocks.TERMITEBLOCK;
        if (blockNorth.equals(blockMound)) {
            this.breakMound(Direction.NORTH, blockNorth);
        }
        if (blockSouth.equals(blockMound)) {
            this.breakMound(Direction.SOUTH, blockSouth);
        }
        if (blockEast.equals(blockMound)) {
            this.breakMound(Direction.EAST, blockEast);
        }
        if (blockWest.equals(blockMound)) {
            this.breakMound(Direction.WEST, blockWest);
        }
    }

    private void breakMound(Direction face, Block block) {
        Block blockMound = ModBlocks.TERMITEBLOCK;
        ItemStack stack = new ItemStack((ItemLike)Items.f_42388_);
        BlockPos blockPos = new BlockPos((Vec3i)this.f_58858_.m_5484_(face, 3));
        for (int y = 0; y < 3; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos newpos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    if (this.f_58857_.m_8055_(newpos).m_60734_() != blockMound) continue;
                    this.f_58857_.m_8055_(newpos).m_60734_().m_6240_(this.f_58857_, (Player)EBFakePlayerFactory.getPlayer((ServerLevel)this.f_58857_), newpos, ModBlocks.TERMITEBLOCK.m_49966_(), null, stack);
                    this.f_58857_.m_7731_(newpos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    private void clickLarveOnDirtBlock() {
        for (int i = 4; i < 8; ++i) {
            if (!((ItemStack)this.zapperItemStacks.get(i)).m_41619_() && this.f_58857_.m_8055_(this.f_58858_.m_142390_(3)).m_60734_() == Blocks.f_50493_) {
                this.f_58857_.m_7731_(this.f_58858_.m_142390_(3), ModBlocks.TERMITEBLOCKA.m_49966_(), 3);
                this.m_7407_(i, 1);
            }
            if (!((ItemStack)this.zapperItemStacks.get(i)).m_41619_() && this.f_58857_.m_8055_(this.f_58858_.m_142383_(3)).m_60734_() == Blocks.f_50493_) {
                this.f_58857_.m_7731_(this.f_58858_.m_142383_(3), ModBlocks.TERMITEBLOCKA.m_49966_(), 3);
                this.m_7407_(i, 1);
            }
            if (!((ItemStack)this.zapperItemStacks.get(i)).m_41619_() && this.f_58857_.m_8055_(this.f_58858_.m_142385_(3)).m_60734_() == Blocks.f_50493_) {
                this.f_58857_.m_7731_(this.f_58858_.m_142385_(3), ModBlocks.TERMITEBLOCKA.m_49966_(), 3);
                this.m_7407_(i, 1);
            }
            if (((ItemStack)this.zapperItemStacks.get(i)).m_41619_() || this.f_58857_.m_8055_(this.f_58858_.m_142386_(3)).m_60734_() != Blocks.f_50493_) continue;
            this.f_58857_.m_7731_(this.f_58858_.m_142386_(3), ModBlocks.TERMITEBLOCKA.m_49966_(), 3);
            this.m_7407_(i, 1);
        }
    }

    private void setDirtBlock() {
        boolean flag = true;
        if (!this.f_58857_.f_46443_) {
            Block blockNorth = this.f_58857_.m_8055_(this.f_58858_.m_142390_(3)).m_60734_();
            Block blockSouth = this.f_58857_.m_8055_(this.f_58858_.m_142383_(3)).m_60734_();
            Block blockEast = this.f_58857_.m_8055_(this.f_58858_.m_142385_(3)).m_60734_();
            Block blockWest = this.f_58857_.m_8055_(this.f_58858_.m_142386_(3)).m_60734_();
            TermiteBlockA blockMound = ModBlocks.TERMITEBLOCKA;
            Block blockMoundI = ModBlocks.TERMITEBLOCK;
            boolean larva = this.checkForLarva();
            for (int i = 0; i < 4; ++i) {
                if (!((ItemStack)this.zapperItemStacks.get(i)).m_41619_() && blockNorth instanceof AirBlock && larva) {
                    this.f_58857_.m_7731_(this.f_58858_.m_142390_(3), Blocks.f_50493_.m_49966_(), 3);
                    this.m_7407_(i, 1);
                    return;
                }
                if (!((ItemStack)this.zapperItemStacks.get(i)).m_41619_() && blockSouth instanceof AirBlock && larva) {
                    this.f_58857_.m_7731_(this.f_58858_.m_142383_(3), Blocks.f_50493_.m_49966_(), 3);
                    this.m_7407_(i, 1);
                    return;
                }
                if (!((ItemStack)this.zapperItemStacks.get(i)).m_41619_() && blockEast instanceof AirBlock && larva) {
                    this.f_58857_.m_7731_(this.f_58858_.m_142385_(3), Blocks.f_50493_.m_49966_(), 3);
                    this.m_7407_(i, 1);
                    return;
                }
                if (((ItemStack)this.zapperItemStacks.get(i)).m_41619_() || !(blockWest instanceof AirBlock) || !larva) continue;
                this.f_58857_.m_7731_(this.f_58858_.m_142386_(3), Blocks.f_50493_.m_49966_(), 3);
                this.m_7407_(i, 1);
                return;
            }
        }
    }

    private boolean checkForLarva() {
        for (int i = 4; i < 8; ++i) {
            if (((ItemStack)this.zapperItemStacks.get(i)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public int m_6643_() {
        return 17;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.zapperItemStacks.get(slot);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.zapperItemStacks, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.zapperItemStacks, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.zapperItemStacks.get(index);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.zapperItemStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(new BlockPos((Vec3i)this.f_58858_)) != this ? false : player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
    }

    protected Component m_6820_() {
        this.name = new TranslatableComponent("Bug Zapper");
        return new TranslatableComponent("Bug Zapper");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inv) {
        return new BugZapperContainer(i, this.f_58858_, inv.f_35978_);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
        this.zapperItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.zapperItemStacks);
    }

    public CompoundTag m_6945_(CompoundTag compoundTag) {
        super.m_6945_(compoundTag);
        if (this.name != null) {
            compoundTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.zapperItemStacks);
        return compoundTag;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? SLOTS_BOTTOM : (side == Direction.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (!this.f_58857_.f_46443_) {
            Item item = stack.m_41720_();
            Block block = Block.m_49814_((Item)item);
            if (index < 4) {
                return block == Blocks.f_50493_;
            }
            if (index > 7 && index < 18) {
                return true;
            }
            if (index > 3 && index < 8) {
                return stack.m_41720_() == EdiblebugsSetup.TERMITELARVA.get();
            }
            return false;
        }
        return true;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN || direction == Direction.UP && index > 7 && index < 17;
    }
}

