/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.modules.fryer;

import com.eractnod.ediblebugs.modules.fryer.Fryer;
import com.eractnod.ediblebugs.modules.fryer.FryerContainer;
import com.eractnod.ediblebugs.recipe.AllRecipes;
import com.eractnod.ediblebugs.recipe.ProcessingRecipe;
import com.eractnod.ediblebugs.setup.ModBlocks;
import com.eractnod.ediblebugs.util.TickerUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class FryerTile
extends BaseContainerBlockEntity
implements TickerUtil.TickableServer,
MenuProvider,
WorldlyContainer {
    private final Map<ResourceLocation, Integer> field_214022_n = Maps.newHashMap();
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1};
    private static final int[] slots_sides = new int[]{1};
    private NonNullList<ItemStack> fryerItemStacks = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private Component name;
    int cookTimeTotal;
    int burnTime;
    int cookTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return FryerTile.this.burnTime;
                }
                case 1: {
                    return FryerTile.this.cookTime;
                }
                case 2: {
                    return FryerTile.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FryerTile.this.burnTime = value;
                    break;
                }
                case 1: {
                    FryerTile.this.cookTime = value;
                    break;
                }
                case 2: {
                    FryerTile.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            FryerTile.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    private LazyOptional<IItemHandler> handlerOpt;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public FryerTile(BlockPos pos, BlockState state) {
        super(ModBlocks.FRYER_TILE, pos, state);
    }

    public void setFurnaceCookTime(int value) {
        this.cookTime = value;
    }

    public void setFurnaceCookTimeTotal(int value) {
        this.cookTimeTotal = value;
    }

    public void setFurnaceBurnTime(int value) {
        this.burnTime = value;
    }

    @Override
    public void updateServer() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.f_58857_.f_46443_) {
            ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(1);
            if (this.isBurning() || !itemstack.m_41619_() && !((ItemStack)this.fryerItemStacks.get(0)).m_41619_()) {
                Recipe irecipe = this.f_58857_.m_7465_().m_44015_(AllRecipes.Types.FRYING, (Container)this, this.f_58857_).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe)) {
                    this.burnTime = this.getBurnTime(itemstack);
                    this.cookTimeTotal = this.getCookedTime();
                    if (this.isBurning()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.fryerItemStacks.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.m_41619_()) {
                            Item item = itemstack.m_41720_();
                            itemstack.m_41774_(1);
                            if (itemstack.m_41619_()) {
                                this.fryerItemStacks.set(1, (Object)itemstack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookedTime();
                        this.smeltItem(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = Mth.m_14045_((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)Fryer.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (flag1) {
            this.m_6596_();
        }
    }

    private void smeltItem(Recipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(0);
            ItemStack itemstack1 = recipe.m_8043_();
            ItemStack itemstack2 = (ItemStack)this.fryerItemStacks.get(2);
            if (itemstack2.m_41619_()) {
                this.fryerItemStacks.set(2, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (!this.f_58857_.f_46443_) {
                this.setRecipeUsed(recipe);
            }
            if (itemstack.m_41720_() == Blocks.f_50057_.m_5456_() && !((ItemStack)this.fryerItemStacks.get(1)).m_41619_() && ((ItemStack)this.fryerItemStacks.get(1)).m_41720_() == Items.f_42446_) {
                this.fryerItemStacks.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
        }
    }

    private void setRecipeUsed(Recipe<?> recipe) {
        if (recipe != null) {
            this.field_214022_n.compute(recipe.m_6423_(), (p_214004_0_, p_214004_1_) -> 1 + (p_214004_1_ == null ? 0 : p_214004_1_));
        }
    }

    private boolean canSmelt(Recipe<?> recipeIn) {
        if (!((ItemStack)this.fryerItemStacks.get(0)).m_41619_() && recipeIn != null) {
            ItemStack itemstack = recipeIn.m_8043_();
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.fryerItemStacks.get(2);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!itemstack1.m_150930_(itemstack.m_41720_())) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= this.m_6893_() && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private int getBurnTime(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, AllRecipes.Types.FRYING);
    }

    private int getCookedTime() {
        return this.f_58857_.m_7465_().m_44015_(AllRecipes.Types.FRYING, (Container)this, this.f_58857_).map(ProcessingRecipe::getCookingTime).orElse(200);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    protected Component m_6820_() {
        this.name = new TranslatableComponent("Fryer");
        return new TranslatableComponent("fryer");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerinventory) {
        return new FryerContainer(id, this.f_58858_, playerinventory.f_35978_);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)compoundTag.m_128461_("CustomName"));
        }
        this.fryerItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.fryerItemStacks);
        this.burnTime = compoundTag.m_128451_("BurnTime");
        this.cookTime = compoundTag.m_128451_("CookTime");
        this.cookTimeTotal = compoundTag.m_128451_("CookTimeTotal");
    }

    public CompoundTag m_6945_(CompoundTag compoundTag) {
        super.m_6945_(compoundTag);
        compoundTag.m_128405_("BurnTime", this.burnTime);
        compoundTag.m_128405_("CookTime", this.cookTime);
        compoundTag.m_128405_("CookTimeTotal", this.cookTimeTotal);
        if (this.name != null) {
            compoundTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.fryerItemStacks);
        return compoundTag;
    }

    public void onLoad() {
        this.onChunkUnloaded();
        this.handlerOpt = LazyOptional.of(() -> this.itemStackHandler);
    }

    public int m_6643_() {
        return this.fryerItemStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.fryerItemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.fryerItemStacks.get(slot);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.fryerItemStacks, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.fryerItemStacks, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(index);
        boolean flag = !stack.m_41619_() && stack.m_41656_(itemstack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack);
        this.fryerItemStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookedTime();
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(new BlockPos((Vec3i)this.f_58858_)) != this ? false : player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.fryerItemStacks.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? slots_bottom : (side == Direction.UP ? slots_top : slots_sides);
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction side) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.fryerItemStacks.get(1);
        return ForgeHooks.getBurnTime((ItemStack)stack, AllRecipes.Types.FRYING) > 0 || stack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || stack.m_41720_() == Items.f_42446_;
    }
}

