/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.recipe;

import com.eractnod.ediblebugs.recipe.FryerRecipe;
import com.eractnod.ediblebugs.recipe.ProcessingRecipe;
import com.eractnod.ediblebugs.recipe.ProcessingRecipeSerializer;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum AllRecipes {
    FRYING(() -> new ProcessingRecipeSerializer<ProcessingRecipe>(FryerRecipe::new, 200), Types.FRYING);

    public RecipeSerializer<?> serializer;
    public Supplier<RecipeSerializer<?>> supplier;
    public RecipeType<? extends Recipe<?>> type;

    private AllRecipes(Supplier<RecipeSerializer<?>> supplier, RecipeType<FryerRecipe> type) {
        this.supplier = supplier;
        this.type = type;
    }

    public static void register(RegistryEvent.Register<RecipeSerializer<?>> event) {
        for (AllRecipes r : AllRecipes.values()) {
            r.serializer = r.supplier.get();
            ResourceLocation location = new ResourceLocation("ediblebugs", AllRecipes.asId(r.name()));
            event.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)r.serializer.setRegistryName(location)));
        }
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ENGLISH);
    }

    public static class Types {
        public static RecipeType<FryerRecipe> FRYING = Types.register("frying");

        static <T extends Recipe<?>> RecipeType<T> register(final String key) {
            return (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(key), (Object)new RecipeType<T>(){

                public String toString() {
                    return key;
                }
            });
        }
    }
}

