/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.util;

import com.eractnod.ediblebugs.modules.bugzapper.BugZapperTile;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ItemUtil {
    public static int doInsertItem(BugZapperTile inv, int startSlot, int endSlot, ItemStack item) {
        return ItemUtil.doInsertItemInv(inv, null, invSlotter.getInstance(startSlot, endSlot), item, null, true);
    }

    private static int doInsertItemInv(BugZapperTile inv, WorldlyContainer sidedInv, ISlotIterator slots, ItemStack item, Direction inventorySide, boolean doInsert) {
        int numInserted = 0;
        int numToInsert = item.m_41613_();
        int firstFreeSlot = -1;
        while (numToInsert > 0 && slots.hasNext()) {
            int slot = slots.nextSlot();
            if (sidedInv != null && !sidedInv.m_7155_(slot, item, inventorySide)) continue;
            ItemStack contents = inv.m_8020_(slot);
            if (contents != null && contents.m_41720_() != Item.m_41439_((Block)Blocks.f_50016_)) {
                int freeSpace;
                if (!ItemUtil.areStackMergable(contents, item) || (freeSpace = Math.min(inv.m_6893_(), contents.m_41741_()) - contents.m_41613_()) <= 0) continue;
                int noToInsert = Math.min(numToInsert, freeSpace);
                ItemStack toInsert = item.m_41777_();
                toInsert.m_41764_(contents.m_41613_() + noToInsert);
                if (sidedInv == null && !inv.m_7013_(slot, toInsert)) continue;
                numInserted += noToInsert;
                numToInsert -= noToInsert;
                if (!doInsert) continue;
                inv.m_6836_(slot, toInsert);
                continue;
            }
            if (firstFreeSlot != -1) continue;
            firstFreeSlot = slot;
        }
        if (numToInsert > 0 && firstFreeSlot != -1) {
            ItemStack toInsert = item.m_41777_();
            toInsert.m_41764_(ItemUtil.min(numToInsert, inv.m_6893_(), toInsert.m_41741_()));
            if (sidedInv != null || inv.m_7013_(firstFreeSlot, toInsert)) {
                numInserted += toInsert.m_41613_();
                numToInsert -= toInsert.m_41613_();
                if (doInsert) {
                    inv.m_6836_(firstFreeSlot, toInsert);
                }
            }
        }
        if (numInserted > 0 && doInsert) {
            inv.m_6596_();
        }
        return numInserted;
    }

    private static final int min(int i1, int i2, int i3) {
        return i1 < i2 ? (i1 < i3 ? i1 : i3) : (i2 < i3 ? i2 : i3);
    }

    public static boolean areStackMergable(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null || !s1.m_41753_() || !s2.m_41753_()) {
            return false;
        }
        if (!s1.m_150930_(s2.m_41720_())) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)s1, (ItemStack)s2);
    }

    private static final class invSlotter
    implements ISlotIterator {
        private static final invSlotter me = new invSlotter();
        private int end;
        private int current;

        private invSlotter() {
        }

        public static final invSlotter getInstance(int start, int end) {
            invSlotter.me.end = end;
            invSlotter.me.current = start;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.current++;
        }

        @Override
        public final boolean hasNext() {
            return this.current < this.end;
        }
    }

    private static interface ISlotIterator {
        public int nextSlot();

        public boolean hasNext();
    }

    private static final class sidedSlotter
    implements ISlotIterator {
        private static final sidedSlotter me = new sidedSlotter();
        private int[] slots;
        private int current;

        private sidedSlotter() {
        }

        public static final sidedSlotter getInstance(int[] slots) {
            sidedSlotter.me.slots = slots;
            sidedSlotter.me.current = 0;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.slots[this.current++];
        }

        @Override
        public final boolean hasNext() {
            return this.slots != null && this.current < this.slots.length;
        }
    }
}

