/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.util.registry.Registry;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public class Codecs {
    public static final Codec<Block> BLOCK = Registry.field_212618_g;
    public static final Codec<Item> ITEM = Registry.field_212630_s;
    public static final Codec<Enchantment> ENCHANTMENT = Registry.field_212628_q;
    public static final Codec<Attribute> ATTRIBUTE = Registry.field_239692_aP_;
    public static final Codec<UUID> UUID_CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    public static final Codec<EquipmentSlotType> EQUIPMENT_SLOT_TYPE = Codec.STRING.xmap(EquipmentSlotType::func_188451_a, EquipmentSlotType::func_188450_d);
    @Deprecated
    public static final Codec<IBlockPosPredicate> BLOCK_PREDICATE = IBlockPosPredicate.CODEC;
    public static final Codec<Integer> HEX_COLOR = Codec.STRING.comapFlatMap(s -> {
        if (s.startsWith("#")) {
            return DataResult.success((Object)Integer.parseInt(s.substring(1), 16));
        }
        return DataResult.error((String)("Coundn't parse color: '" + s + '\''));
    }, i -> String.format("#%06X", i));
    public static final Codec<Integer> RGB_COLOR = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("r").forGetter(i -> i >> 16 & 0xFF), (App)Codec.INT.fieldOf("g").forGetter(i -> i >> 8 & 0xFF), (App)Codec.INT.fieldOf("b").forGetter(i -> i & 0xFF)).apply((Applicative)builder, (r, g, b) -> (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF));
    public static final Codec<Integer> COLOR = Codec.either((Codec)Codec.INT, (Codec)Codec.either(HEX_COLOR, RGB_COLOR).xmap(e -> (Integer)e.map(Function.identity(), Function.identity()), Either::left)).xmap(e -> (Integer)e.map(Function.identity(), Function.identity()), Either::left);
    private static final Codec<AttributeModifier.Operation> ATTRIBUTE_MODIFIER_OPERATION = Codec.STRING.comapFlatMap(s -> {
        switch (s) {
            case "addition": {
                return DataResult.success((Object)AttributeModifier.Operation.ADDITION);
            }
            case "multiply_base": {
                return DataResult.success((Object)AttributeModifier.Operation.MULTIPLY_BASE);
            }
            case "multiply_total": {
                return DataResult.success((Object)AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
        }
        return DataResult.error((String)("Coundn't parse AttributeModifier Operation: '" + s + '\''));
    }, o -> {
        switch (o) {
            case MULTIPLY_BASE: {
                return "multiply_base";
            }
            case MULTIPLY_TOTAL: {
                return "multiply_total";
            }
        }
        return "addition";
    });
    public static final Codec<AttributeModifier> ATTRIBUTE_MODIFIER = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(AttributeModifier::func_111166_b), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeModifier::func_111164_d), (App)ATTRIBUTE_MODIFIER_OPERATION.fieldOf("operation").forGetter(AttributeModifier::func_220375_c)).apply((Applicative)builder, AttributeModifier::new));
}

