/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.codec.CodecHelper;

public interface IDataManager<T>
extends IFutureReloadListener,
Codec<T>,
Keyable {
    public Class<T> getContentType();

    public String getFolder();

    public Map<ResourceLocation, T> getData();

    public void setData(Map<ResourceLocation, T> var1);

    default public T get(ResourceLocation id) {
        return this.getData().get(id);
    }

    default public Lazy<T> getLazy(ResourceLocation id) {
        return Lazy.of(() -> this.get(id));
    }

    default public T getOrDefault(ResourceLocation id, T defaultValue) {
        return this.getData().getOrDefault(id, defaultValue);
    }

    default public Optional<T> getOptional(ResourceLocation id) {
        return this.getData().containsKey(id) ? Optional.of(this.get(id)) : Optional.empty();
    }

    default public ResourceLocation getId(T value) {
        return this.getData().entrySet().stream().filter(e -> e.getValue().equals(value)).map(Map.Entry::getKey).findAny().orElse(DataPackAnvilApi.ID_NONE);
    }

    default public List<T> getAll(Collection<ResourceLocation> ids) {
        return ids.stream().map(this::get).collect(Collectors.toList());
    }

    default public Lazy<List<T>> getAllLazy(Collection<ResourceLocation> ids) {
        return Lazy.of(() -> this.getAll(ids));
    }

    default public boolean hasId(ResourceLocation id) {
        return this.getData().containsKey(id);
    }

    default public boolean has(T value) {
        return this.getData().containsValue(value);
    }

    default public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return ResourceLocation.field_240908_a_.decode(ops, input).map(pair -> pair.mapFirst(this::get));
    }

    default public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        return ResourceLocation.field_240908_a_.encode((Object)this.getId(input), ops, prefix);
    }

    default public <U> Stream<U> keys(DynamicOps<U> dynOps) {
        return this.getData().keySet().stream().map(id -> dynOps.createString(id.toString()));
    }

    public static <T> Builder<T> builder(Class<T> type, String folder) {
        try {
            Constructor<?> constructor = Class.forName("sirttas.dpanvil.data.manager.SimpleDataManagerBuilder", true, IDataManager.class.getClassLoader()).getConstructor(Class.class, String.class);
            return (Builder)constructor.newInstance(type, folder);
        }
        catch (Exception e) {
            DataPackAnvilApi.LOGGER.error("Couldn't get constructor", (Throwable)e);
            return null;
        }
    }

    public static interface Builder<T> {
        public Builder<T> withIdSetter(BiConsumer<T, ResourceLocation> var1);

        default public Builder<T> withDefault(T defaultValue) {
            return this.withDefault(id -> defaultValue);
        }

        public Builder<T> withDefault(Function<ResourceLocation, T> var1);

        public <R> Builder<T> merged(Function<Stream<R>, T> var1, Function<JsonElement, R> var2);

        default public <R> Builder<T> merged(Function<Stream<R>, T> merger, Decoder<R> rawDecoder) {
            return this.merged(merger, (JsonElement json) -> CodecHelper.decode(rawDecoder, json));
        }

        default public Builder<T> merged(Function<Stream<T>, T> merger) {
            return this.merged(merger, (Function)null);
        }

        public IDataManager<T> build();
    }
}

