/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.ListBlockPredicate;

public final class AndBlockPredicate
extends ListBlockPredicate {
    public static final String NAME = "and";
    @ObjectHolder(value="dpanvil:and")
    public static BlockPosPredicateType<AndBlockPredicate> TYPE;
    public static final Codec<AndBlockPredicate> CODEC;

    public AndBlockPredicate(IBlockPosPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    public AndBlockPredicate(Iterable<IBlockPosPredicate> predicates) {
        super(predicates);
    }

    @Override
    public boolean test(IWorldReader world, BlockPos pos) {
        return this.predicates.stream().allMatch(predicate -> predicate.test(world, pos));
    }

    public BlockPosPredicateType<AndBlockPredicate> getType() {
        return TYPE;
    }

    @Override
    public IBlockPosPredicate and(IBlockPosPredicate ... predicates) {
        return new AndBlockPredicate(this.merge(Lists.newArrayList((Object[])predicates), AndBlockPredicate.class));
    }

    static {
        CODEC = AndBlockPredicate.codec(AndBlockPredicate::new);
    }
}

