/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.match;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockStatePredicate;

public final class MatchBlocksPredicate
implements IBlockStatePredicate {
    public static final String NAME = "blocks";
    @ObjectHolder(value="dpanvil:blocks")
    public static BlockPosPredicateType<MatchBlocksPredicate> TYPE;
    public static final Codec<MatchBlocksPredicate> CODEC;
    private final List<Block> blocks;

    public MatchBlocksPredicate(Block ... blocks) {
        this.blocks = ImmutableList.copyOf((Object[])blocks);
    }

    public MatchBlocksPredicate(Iterable<Block> blocks) {
        this.blocks = ImmutableList.copyOf(blocks);
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.contains(state.func_177230_c());
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public BlockPosPredicateType<MatchBlocksPredicate> getType() {
        return TYPE;
    }

    static {
        CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codecs.BLOCK.listOf().fieldOf(NAME).forGetter(MatchBlocksPredicate::getBlocks)).apply((Applicative)builder, MatchBlocksPredicate::new));
    }
}

