/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.tag;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagBuilder;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;

public abstract class DataTagsProvider<T>
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final IDataManager<T> manager;
    protected final Map<ResourceLocation, ITag.Builder> tagToBuilder = Maps.newLinkedHashMap();
    protected final String modId;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;

    protected DataTagsProvider(DataGenerator generatorIn, IDataManager<T> manager, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.generator = generatorIn;
        this.manager = manager;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(ResourcePackType.SERVER_DATA, ".json", "dpanvil_tags/" + this.getTagFolder());
    }

    protected abstract void registerTags();

    public void func_200398_a(DirectoryCache cache) {
        this.tagToBuilder.clear();
        this.registerTags();
        Tag itag = Tag.func_241284_a_();
        Function<ResourceLocation, ITag> function = arg_0 -> this.lambda$act$0((ITag)itag, arg_0);
        Function<ResourceLocation, Object> function1 = key -> this.manager.getOptional((ResourceLocation)key).orElse(null);
        this.tagToBuilder.forEach((tagName, builder) -> {
            List list = builder.func_232963_b_(function, function1).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", tagName, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonobject = builder.func_232965_c_();
            Path path = this.makePath((ResourceLocation)tagName);
            if (path == null) {
                return;
            }
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                DataPackAnvilApi.LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private boolean missing(ITag.Proxy reference) {
        ITag.ITagEntry entry = reference.func_232968_a_();
        if (entry instanceof ITag.TagEntry) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(((ITag.TagEntry)entry).getId(), this.resourceType);
        }
        return false;
    }

    protected String getTagFolder() {
        return this.manager.getFolder();
    }

    protected Path makePath(ResourceLocation id) {
        return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/" + "dpanvil_tags/" + this.getTagFolder() + "/" + id.func_110623_a() + ".json");
    }

    protected Builder getOrCreateBuilder(ITag.INamedTag<T> tag) {
        return new Builder(this.createBuilderIfAbsent(tag), this.modId);
    }

    protected ITag.Builder createBuilderIfAbsent(ITag.INamedTag<T> tag) {
        return this.tagToBuilder.computeIfAbsent(tag.func_230234_a_(), key -> {
            this.existingFileHelper.trackGenerated(key, this.resourceType);
            return new ITag.Builder();
        });
    }

    private /* synthetic */ ITag lambda$act$0(ITag itag, ResourceLocation key) {
        return this.tagToBuilder.containsKey(key) ? itag : null;
    }

    public class Builder
    implements IForgeTagBuilder<T> {
        private final ITag.Builder builder;
        private final String id;

        private Builder(ITag.Builder builder, String id) {
            this.builder = builder;
            this.id = id;
        }

        public Builder addItemEntry(T item) {
            this.builder.func_232961_a_(DataTagsProvider.this.manager.getId(item), this.id);
            return this;
        }

        public Builder addTag(ITag.INamedTag<T> tag) {
            this.builder.func_232964_b_(tag.func_230234_a_(), this.id);
            return this;
        }

        @SafeVarargs
        public final Builder add(T ... toAdd) {
            Stream.of(toAdd).map(DataTagsProvider.this.manager::getId).forEach(key -> this.builder.func_232961_a_(key, this.id));
            return this;
        }

        @SafeVarargs
        public final Builder add(ResourceLocation ... toAdd) {
            Stream.of(toAdd).forEach(key -> this.builder.func_232961_a_(key, this.id));
            return this;
        }

        public Builder add(ITag.ITagEntry tag) {
            this.builder.func_232955_a_(tag, this.id);
            return this;
        }

        public ITag.Builder getInternalBuilder() {
            return this.builder;
        }

        public String getModID() {
            return this.id;
        }
    }
}

