/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.event.DataPackReloadCompletEvent;
import sirttas.dpanvil.interaction.jei.JeiLoadDelayer;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dpanvil")
public class DataHandler {
    private static RecipeManager recipeManager = null;
    private static ITagCollectionSupplier tagManager = null;
    private static Map<Class<? extends Event>, Boolean> map = Maps.newHashMap();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipesUpdate(RecipesUpdatedEvent event) {
        recipeManager = event.getRecipeManager();
        DataHandler.process(event.getClass());
    }

    @SubscribeEvent
    public static void onVanillaTagsUpdate(TagsUpdatedEvent.VanillaTagTypes event) {
        tagManager = event.getTagManager();
        DataHandler.process(event.getClass());
    }

    @SubscribeEvent
    public static void onCustomTagsUpdate(TagsUpdatedEvent.CustomTagTypes event) {
        tagManager = event.getTagManager();
        DataHandler.process(event.getClass());
    }

    public static void onDPAnvilUpdate() {
        DataHandler.process(DataPackReloadCompletEvent.class);
    }

    private static void process(Class<? extends Event> clazz) {
        map.put(clazz, true);
        if (map.values().stream().allMatch(b -> b)) {
            DataPackAnvil.ANNOTATION_PROCESSOR.applyDataHolder();
            MinecraftForge.EVENT_BUS.post((Event)new DataPackReloadCompletEvent(recipeManager, tagManager, DataPackAnvil.WRAPPER.getDataManagers()));
            JeiLoadDelayer.loadJEI();
            recipeManager = null;
            tagManager = null;
            map.keySet().forEach(k -> map.put((Class<? extends Event>)k, false));
        }
    }

    static {
        map.put(RecipesUpdatedEvent.class, false);
        map.put(TagsUpdatedEvent.VanillaTagTypes.class, false);
        map.put(TagsUpdatedEvent.CustomTagTypes.class, false);
        map.put(DataPackReloadCompletEvent.class, false);
    }
}

